/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.cache;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.apache.jena.atlas.logging.Log;

public class Treeprinter {
    public boolean ready = this.initialize();
    BufferedWriter bwStanford;
    BufferedWriter bwClearnlp;

    public String printTreeStanford(HAWKQuestion q) {
        String treeString = q.getTree().toString();
        if (this.ready) {
            try {
                this.bwStanford.write(q.getLanguageToQuestion().toString());
                this.bwStanford.newLine();
                this.bwStanford.write(treeString);
                this.bwStanford.newLine();
                this.bwStanford.newLine();
                this.bwStanford.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            Log.debug(Treeprinter.class, (String)"Printer not ready!");
        }
        return treeString;
    }

    public String printTreeStanford(HAWKQuestion q, String s) {
        String treeString = s;
        if (this.ready) {
            try {
                this.bwStanford.write(q.getLanguageToQuestion().toString());
                this.bwStanford.newLine();
                this.bwStanford.write(treeString);
                this.bwStanford.newLine();
                this.bwStanford.newLine();
                this.bwStanford.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            Log.debug(Treeprinter.class, (String)"Printer not ready!");
        }
        return treeString;
    }

    public String printTreeClearnlp(HAWKQuestion q) {
        String treeString = q.getTree().toString();
        if (this.ready) {
            try {
                this.bwClearnlp.write(q.getLanguageToQuestion().toString());
                this.bwClearnlp.newLine();
                this.bwClearnlp.write(q.getTree().toString());
                this.bwClearnlp.newLine();
                this.bwClearnlp.newLine();
                this.bwClearnlp.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            Log.debug(Treeprinter.class, (String)"Printer not ready!");
        }
        return treeString;
    }

    boolean initialize() {
        try {
            SimpleDateFormat sdfDate = new SimpleDateFormat("dd.MM_HH.mm");
            Date now = new Date();
            String strDate = sdfDate.format(now);
            this.bwStanford = new BufferedWriter(new FileWriter("stanford" + strDate + ".txt", true));
            this.bwClearnlp = new BufferedWriter(new FileWriter("clearnlp" + strDate + ".txt", true));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    public void close() {
        this.closeStanford();
        this.closeClearnlp();
    }

    public void closeStanford() {
        if (this.bwStanford != null) {
            try {
                this.bwStanford.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void closeClearnlp() {
        if (this.bwClearnlp != null) {
            try {
                this.bwClearnlp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

