/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.cache;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class StorageHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T readFromFile(String filename) throws IOException, ClassNotFoundException {
        Serializable object = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(filename);
            ois = new ObjectInputStream(fis);
            object = (Serializable)ois.readObject();
        }
        finally {
            try {
                ois.close();
                fis.close();
            }
            catch (Exception exception) {}
        }
        return (T)object;
    }

    public static <T extends Serializable> T readFromFileSavely(String filename) {
        Serializable object = null;
        try {
            object = StorageHelper.readFromFile((String)filename);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't load object from file (\"" + filename + "\").", (Throwable)e);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void storeToFile(T object, String filename) throws IOException {
        ObjectOutputStream oout = null;
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(filename);
            oout = new ObjectOutputStream(fout);
            oout.writeObject(object);
        }
        finally {
            try {
                oout.close();
                fout.close();
            }
            catch (Exception e) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static <T extends Serializable> boolean storeToFileSavely(T object, String filename) {
        if (object == null) {
            LOGGER.error("Can't serialize null.");
            return false;
        }
        try {
            StorageHelper.storeToFile(object, (String)filename);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't store " + object.getClass().getSimpleName() + " object to file.", (Throwable)e);
            return false;
        }
    }
}

