/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.webservice;

import com.google.common.base.Joiner;
import java.util.List;
import org.aksw.hawk.controller.AbstractPipeline;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.ranking.BucketRanker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="searchExecutor")
public class SearchExecutor {
    private AbstractPipeline pipeline;
    private Logger log = LoggerFactory.getLogger(SearchExecutor.class);

    public void setPipeline(AbstractPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public String runPipeline(String question) {
        HAWKQuestion q = new HAWKQuestion();
        q.getLanguageToQuestion().put("en", question);
        this.log.info("Run pipeline on " + (String)q.getLanguageToQuestion().get("en"));
        List answers = this.pipeline.getAnswersToQuestion(q);
        BucketRanker bucket_ranker = new BucketRanker();
        this.log.info("Bucket-based ranking");
        List rankedAnswer = bucket_ranker.rank(answers, q);
        this.log.info(Joiner.on((String)"\n\t").join((Iterable)rankedAnswer));
        q.setFinalAnswer(rankedAnswer);
        return q.getJSONStatus();
    }
}

