/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.webservice;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.gerbil.io.nif.impl.TurtleNIFParser;
import org.aksw.gerbil.io.nif.impl.TurtleNIFWriter;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.data.DocumentImpl;
import org.aksw.gerbil.transfer.nif.data.NamedEntity;
import org.aksw.hawk.controller.StanfordNLPConnector;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.nouncombination.NounCombinationChain;
import org.aksw.hawk.nouncombination.NounCombiners;
import org.aksw.qa.commons.datastructure.Entity;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NounCombinationWeb {
    NounCombinationChain chainHawkRules;
    StanfordNLPConnector stanford;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public NounCombinationWeb(StanfordNLPConnector stanford) {
        this.stanford = stanford;
        this.chainHawkRules = new NounCombinationChain(NounCombiners.HawkRules, new NounCombiners[0]);
    }

    public String nifToAnswerNif(String nifString) {
        TurtleNIFParser parser = new TurtleNIFParser();
        List docs = null;
        try {
            docs = parser.parseNIF(nifString);
            if (docs == null) {
                throw new IOException("nif==null");
            }
        }
        catch (Exception e) {
            this.log.debug("Couldnt parse input Nif", (Throwable)e);
            return "Invalid input";
        }
        String questionString = ((Document)docs.get(0)).getText();
        return this.stringToNif(questionString);
    }

    public String stringToNif(String questionString) {
        HAWKQuestion q = new HAWKQuestion();
        q.getLanguageToQuestion().put("en", questionString);
        this.stanford.parseTree(q, null);
        this.chainHawkRules.runChain(q);
        List nounPhrases = (List)q.getLanguageToNounPhrases().get("en");
        if (nounPhrases == null) {
            return null;
        }
        DocumentImpl newDoc = new DocumentImpl(questionString);
        for (Entity entity : nounPhrases) {
            int offset = 0;
            ArrayList<String> sentence = new ArrayList<String>(Arrays.asList(questionString.split(" ")));
            for (int i = 0; i < entity.getOffset() - 1; ++i) {
                offset += sentence.get(i).length() + 1;
            }
            NamedEntity span = new NamedEntity(offset, entity.getLabel().length(), ((Resource)entity.getUris().get(0)).getURI());
            newDoc.addMarking((Marking)span);
        }
        ArrayList<Document> newDocs = new ArrayList<Document>(Arrays.asList(newDoc));
        TurtleNIFWriter writer = new TurtleNIFWriter();
        return writer.writeNIF(newDocs);
    }
}

