/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.webservice;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.concurrent.Future;
import org.aksw.hawk.controller.PipelineStanford;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.ranking.BucketRanker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

@Service(value="asyncSearchExecutor")
public class AsyncSearchExecutor {
    private PipelineStanford pipeline = new PipelineStanford();
    private Logger log = LoggerFactory.getLogger(AsyncSearchExecutor.class);

    @Async
    public Future<HAWKQuestion> search(HAWKQuestion q) {
        this.log.info("Run pipeline on " + (String)q.getLanguageToQuestion().get("en"));
        List answers = this.pipeline.getAnswersToQuestion(q);
        BucketRanker bucket_ranker = new BucketRanker();
        this.log.info("Bucket-based ranking");
        List rankedAnswer = bucket_ranker.rank(answers, q);
        this.log.info(Joiner.on((String)"\n\t").join((Iterable)rankedAnswer));
        q.setFinalAnswer(rankedAnswer);
        return new AsyncResult((Object)q);
    }
}

