/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.ranking;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.aksw.hawk.cache.StorageHelper;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBasedRankerDB {
    private Logger log = LoggerFactory.getLogger(FeatureBasedRankerDB.class);

    public Set<SPARQLQuery> readRankings() {
        HashSet set = Sets.newHashSet();
        for (File f : new File("c:/ranking/").listFiles()) {
            this.log.debug("Reading file for ranking: " + f);
            set.add((SPARQLQuery)StorageHelper.readFromFileSavely((String)f.toString()));
        }
        return set;
    }

    public void store(IQuestion q, Set<SPARQLQuery> queries) {
        for (SPARQLQuery query : queries) {
            int hash = query.hashCode();
            String serializedFileName = this.getFileName(hash);
            StorageHelper.storeToFileSavely((Serializable)query, (String)serializedFileName);
        }
    }

    private String getFileName(int hash) {
        String serializedFileName = "c:/ranking/" + hash + ".question";
        return serializedFileName;
    }
}

