/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.ranking;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.hawk.datastructures.Answer;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.ranking.FeatureBasedRanker;
import org.aksw.hawk.ranking.FeatureBasedRankerDB;
import org.aksw.hawk.ranking.Ranking;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBasedRanker
implements Ranking {
    private static Logger log = LoggerFactory.getLogger(FeatureBasedRanker.class);
    private FeatureBasedRankerDB db = new FeatureBasedRankerDB();
    private Map<String, Double> vec;
    private Collection<Feature> features;

    public void learn(IQuestion q, Set<SPARQLQuery> queries) {
        this.db.store(q, queries);
    }

    public List<Answer> rank(List<Answer> answers, HAWKQuestion q) {
        HashMap buckets = Maps.newHashMap();
        for (Answer answer : answers) {
            Map calculateRanking = this.calculateRanking(answer.query);
            double d = this.cosinus(calculateRanking, this.vec);
            answer.score = d;
            buckets.put(answer, answer.score);
        }
        LinkedList tmplist = new LinkedList(buckets.entrySet());
        Collections.sort(tmplist, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<Answer> list = new ArrayList<Answer>();
        for (Map.Entry entry : tmplist) {
            list.add((Answer)entry.getKey());
        }
        return list;
    }

    public void setFeatures(Collection<Feature> features) {
        this.features = features;
    }

    public void train() {
        Set queries = this.db.readRankings();
        this.vec = Maps.newHashMap();
        for (SPARQLQuery q : queries) {
            Map tmp = this.calculateRanking(q);
            for (String key : tmp.keySet()) {
                System.out.println(key);
                if (this.vec.containsKey(key)) {
                    this.vec.put(key, (Double)tmp.get(key) + (Double)this.vec.get(key));
                    continue;
                }
                this.vec.put(key, tmp.get(key));
            }
        }
        for (String key : this.vec.keySet()) {
            this.vec.put(key, (Double)this.vec.get(key) / (double)queries.size());
            log.debug(key + ": " + this.vec.get(key));
        }
    }

    private void addOneToMapAtKey(Map<String, Double> map, String key) {
        if (map.containsKey(key)) {
            map.put(key, map.get(key) + 1.0);
        } else {
            map.put(key, 1.0);
        }
    }

    private Map<String, Double> calculateRanking(SPARQLQuery q) {
        Collections.sort(q.constraintTriples);
        HashMap featureValues = Maps.newHashMap();
        System.out.println("evaluating: " + q.toString());
        for (Feature feature : this.features) {
            System.out.println("feature:");
            System.out.println(feature);
            switch (2.$SwitchMap$org$aksw$hawk$ranking$FeatureBasedRanker$Feature[feature.ordinal()]) {
                case 1: {
                    featureValues.putAll(this.usedPredicates(q));
                    break;
                }
                case 2: {
                    featureValues.putAll(this.usedPattern(q));
                    break;
                }
                case 3: {
                    featureValues.put("feature:numberOfConstraints", this.numberOfConstraints(q));
                    break;
                }
                case 4: {
                    featureValues.put("feature:numberOfTermsInTextQuery", this.numberOfTermsInTextQuery(q));
                    break;
                }
                case 5: {
                    featureValues.put("feature:numberOfTypes", this.numberOfTypes(q));
                    break;
                }
            }
        }
        return featureValues;
    }

    private double cosinus(Map<String, Double> calculateRanking, Map<String, Double> goldVector) {
        double dotProduct = 0.0;
        for (String key : goldVector.keySet()) {
            if (!calculateRanking.containsKey(key)) continue;
            dotProduct += goldVector.get(key) * calculateRanking.get(key);
        }
        double magnitude_A = 0.0;
        for (String key : goldVector.keySet()) {
            magnitude_A += Math.sqrt(goldVector.get(key) * goldVector.get(key));
        }
        double magnitude_B = 0.0;
        for (String key : calculateRanking.keySet()) {
            magnitude_B += Math.sqrt(calculateRanking.get(key) * calculateRanking.get(key));
        }
        return dotProduct / (magnitude_A * magnitude_B);
    }

    private double numberOfConstraints(SPARQLQuery query) {
        return query.constraintTriples.size();
    }

    private Double numberOfTermsInTextQuery(SPARQLQuery q) {
        Iterator iterator = q.textMapFromVariableToSingleFuzzyToken.keySet().iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            return ((Set)q.textMapFromVariableToSingleFuzzyToken.get(key)).size();
        }
        return 0.0;
    }

    private Double numberOfTypes(SPARQLQuery q) {
        String[] split = new String[3];
        double numberOfTypes = 0.0;
        for (String triple : q.constraintTriples) {
            split = triple.split(" ");
            if (!split[1].equals("a")) continue;
            numberOfTypes += 1.0;
        }
        return numberOfTypes;
    }

    private Map<String, Double> usedPattern(SPARQLQuery q) {
        HashMap map = Maps.newHashMap();
        String[] split = new String[3];
        String textNode = null;
        Iterator iterator = q.textMapFromVariableToCombinedNNExactMatchToken.keySet().iterator();
        while (iterator.hasNext()) {
            String var;
            textNode = var = (String)iterator.next();
        }
        List constraintTriples = q.constraintTriples;
        for (String triple : constraintTriples) {
            String key;
            triple = triple.replaceAll("\\s+", " ");
            split = triple.split(" ");
            String subject = split[0];
            String predicate = split[1];
            String object = split[2];
            if (subject.equals(textNode) && predicate.startsWith("?") && object.startsWith("?")) {
                key = "textNode_?var_?var";
                this.addOneToMapAtKey((Map)map, key);
                continue;
            }
            if (subject.equals(textNode) && !predicate.startsWith("?") && object.startsWith("?")) {
                key = "textNode_bound_?var";
                this.addOneToMapAtKey((Map)map, key);
                continue;
            }
            if (subject.equals(textNode) && predicate.startsWith("?") && !object.startsWith("?")) {
                key = "textNode_?var_bound";
                this.addOneToMapAtKey((Map)map, key);
                continue;
            }
            if (subject.equals(textNode) && !predicate.startsWith("?") && !object.startsWith("?")) {
                key = "textNode_bound_bound";
                this.addOneToMapAtKey((Map)map, key);
                continue;
            }
            if (object.equals(textNode) && predicate.startsWith("?") && subject.startsWith("?")) {
                key = "?var_?var_textNode";
                this.addOneToMapAtKey((Map)map, key);
                continue;
            }
            if (object.equals(textNode) && !predicate.startsWith("?") && subject.startsWith("?")) {
                key = "?var_bound_textNode";
                this.addOneToMapAtKey((Map)map, key);
                continue;
            }
            if (object.equals(textNode) && predicate.startsWith("?") && !subject.startsWith("?")) {
                key = "bound_?var_textNode";
                this.addOneToMapAtKey((Map)map, key);
                continue;
            }
            if (!object.equals(textNode) || predicate.startsWith("?") || subject.startsWith("?")) continue;
            key = "bound_bound_textNode";
            this.addOneToMapAtKey((Map)map, key);
        }
        return map;
    }

    private Map<String, Double> usedPredicates(SPARQLQuery q) {
        HashMap map = Maps.newHashMap();
        String[] split = new String[3];
        for (String triple : q.constraintTriples) {
            split = (triple = triple.replaceAll("\\s+", " ")).split(" ");
            if (map.containsKey(split[1])) {
                double tmp = (Double)map.get(split[1]);
                map.put(split[1], tmp + 1.0);
                continue;
            }
            map.put(split[1], 1.0);
        }
        return map;
    }
}

