/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.querybuilding;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.aksw.hawk.datastructures.Answer;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.pruner.SPARQLQueryPruner;
import org.aksw.hawk.querybuilding.RecursiveSparqlQueryBuilder;
import org.aksw.qa.commons.sparql.SPARQL;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLQueryBuilder {
    int numberOfOverallQueriesExecuted = 0;
    private static Logger log = LoggerFactory.getLogger(SPARQLQueryBuilder.class);
    private SPARQL sparql;
    private RecursiveSparqlQueryBuilder recursiveSparqlQueryBuilder;
    private SPARQLQueryPruner sparqlQueryPruner;

    public SPARQLQueryBuilder(SPARQL sparql) {
        this.sparql = sparql;
        this.recursiveSparqlQueryBuilder = new RecursiveSparqlQueryBuilder();
        this.sparqlQueryPruner = new SPARQLQueryPruner(sparql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Answer> build(HAWKQuestion q) {
        ArrayList answer = Lists.newArrayList();
        try {
            Set queryStrings = this.recursiveSparqlQueryBuilder.start(this, q);
            queryStrings = this.sparqlQueryPruner.prune(queryStrings, q);
            int cardinality = this.cardinality(q, queryStrings);
            JSONObject tmp = new JSONObject();
            tmp.put((Object)"label", (Object)"Cardinality of question results");
            tmp.put((Object)"value", (Object)cardinality);
            q.getPruning_messages().add((Object)tmp);
            log.debug("Cardinality:" + ((String)q.getLanguageToQuestion().get("en")).toString() + "-> " + cardinality);
            int i = 0;
            for (SPARQLQuery query : queryStrings) {
                for (String queryString : query.generateQueries()) {
                    log.debug(i++ + "/" + queryStrings.size() * query.generateQueries().size() + "= " + queryString);
                    Answer a = new Answer();
                    a.answerSet = this.sparql.sparql(queryString);
                    a.query = query;
                    a.queryString = queryString;
                    a.question_id = q.getId();
                    a.question = ((String)q.getLanguageToQuestion().get("en")).toString();
                    if (!a.answerSet.isEmpty()) {
                        answer.add(a);
                    }
                    ++this.numberOfOverallQueriesExecuted;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            System.gc();
        }
        JSONObject tmp = new JSONObject();
        tmp.put((Object)"label", (Object)"Number of sofar executed queries");
        tmp.put((Object)"value", (Object)this.numberOfOverallQueriesExecuted);
        q.getPruning_messages().add((Object)tmp);
        log.debug("Number of sofar executed queries: " + this.numberOfOverallQueriesExecuted);
        return answer;
    }

    private int cardinality(HAWKQuestion q, Set<SPARQLQuery> queryStrings) {
        int cardinality = q.getCardinality();
        for (SPARQLQuery s : queryStrings) {
            s.setLimit(cardinality);
        }
        return cardinality;
    }
}

