/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.querybuilding;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.index.DBOIndex;
import org.aksw.hawk.nlp.MutableTree;
import org.aksw.hawk.nlp.MutableTreeNode;
import org.aksw.hawk.util.JSONStatusBuilder;
import org.aksw.qa.annotation.index.IndexDBO_classes;
import org.aksw.qa.annotation.index.IndexDBO_properties;
import org.aksw.qa.commons.sparql.SPARQL;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Annotater {
    Logger log = LoggerFactory.getLogger(Annotater.class);
    IndexDBO_classes classesIndex = new IndexDBO_classes();
    IndexDBO_properties propertiesIndex = new IndexDBO_properties();
    DBOIndex dboIndex = new DBOIndex();
    Set<String> blacklist = Sets.newHashSet((Object[])new String[]{"people"});
    private SPARQL sparql;

    public Annotater(SPARQL sparql) {
        this.sparql = sparql;
    }

    public void annotateTree(HAWKQuestion q) {
        MutableTree tree = q.getTree();
        this.annotateProjectionLeftTree(tree);
        this.annotateVerbs(tree);
        this.annotateNouns(tree);
        q.setTree_final(JSONStatusBuilder.treeToJSON((MutableTree)q.getTree()));
    }

    private void annotateNouns(MutableTree tree) {
        Stack<MutableTreeNode> stack = new Stack<MutableTreeNode>();
        stack.push(tree.getRoot());
        while (!stack.isEmpty()) {
            MutableTreeNode tmp = (MutableTreeNode)stack.pop();
            String label = tmp.label;
            String posTag = tmp.posTag;
            if (this.blacklist.contains(label)) continue;
            if (posTag.matches("NN(.)*") && tmp.getAnnotations().isEmpty()) {
                List search = this.classesIndex.search(label);
                if (!search.isEmpty()) {
                    for (String uri : search) {
                        tmp.addAnnotation(uri);
                    }
                } else if (!this.propertiesIndex.search(label).isEmpty()) {
                    search = this.propertiesIndex.search(label);
                    for (String uri : search) {
                        tmp.addAnnotation(uri);
                    }
                } else {
                    search = this.dboIndex.search(label);
                    for (String uri : search) {
                        tmp.addAnnotation(uri);
                    }
                }
                if (tmp.getAnnotations().isEmpty()) {
                    if (tmp.lemma != null) {
                        label = tmp.lemma;
                    }
                    search = this.classesIndex.search(label);
                    for (String uri : search) {
                        tmp.addAnnotation(uri);
                    }
                    search = this.propertiesIndex.search(label);
                    for (String uri : search) {
                        tmp.addAnnotation(uri);
                    }
                    search = this.dboIndex.search(label);
                    for (String uri : search) {
                        tmp.addAnnotation(uri);
                    }
                }
            } else {
                this.log.debug("Not annotated node: " + tmp);
            }
            for (MutableTreeNode child : tmp.getChildren()) {
                stack.push(child);
            }
        }
    }

    private void annotateVerbs(MutableTree tree) {
        Stack<MutableTreeNode> stack = new Stack<MutableTreeNode>();
        stack.push(tree.getRoot());
        while (!stack.isEmpty()) {
            MutableTreeNode tmp = (MutableTreeNode)stack.pop();
            String label = tmp.label;
            String posTag = tmp.posTag;
            if (posTag.matches("VB(.)*")) {
                List search = this.propertiesIndex.search(label);
                if (search.isEmpty() && tmp.lemma != null) {
                    search = this.propertiesIndex.search(tmp.lemma);
                } else if (search.isEmpty()) {
                    search = this.dboIndex.search(label);
                }
                search = this.rank(search);
                for (String uri : search) {
                    tmp.addAnnotation(uri);
                }
                this.log.debug(Joiner.on((String)", ").join((Iterable)tmp.getAnnotations()));
            }
            for (MutableTreeNode child : tmp.getChildren()) {
                stack.push(child);
            }
        }
    }

    private List<String> rank(List<String> search) {
        ArrayList predicates = Lists.newArrayList();
        try {
            int maxNum = 0;
            String maxPred = "";
            for (String predicate : search) {
                QueryExecution qe = this.sparql.qef.createQueryExecution("SELECT count(*) WHERE { ?const <" + predicate + "> ?var.}");
                if (qe == null) continue;
                ResultSet results = qe.execSelect();
                while (results.hasNext()) {
                    int predicateCount = results.next().get(".1").asLiteral().getInt();
                    this.log.debug(predicate + "\t" + predicateCount);
                    if (predicateCount <= maxNum || predicate.contains("Year") || predicate.contains("Date")) continue;
                    maxNum = predicateCount;
                    maxPred = predicate;
                }
            }
            predicates.add(maxPred);
        }
        catch (Exception e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return predicates;
    }

    private void annotateProjectionLeftTree(MutableTree tree) {
        block14: {
            String posTag;
            block19: {
                String label;
                MutableTreeNode tmp;
                block20: {
                    block18: {
                        block15: {
                            block16: {
                                block17: {
                                    Stack stack = new Stack();
                                    if (tree.getRoot() == null || tree.getRoot().getChildren() == null || tree.getRoot().getChildren().isEmpty()) break block14;
                                    stack.push(tree.getRoot().getChildren().get(0));
                                    if (stack.isEmpty()) break block14;
                                    tmp = (MutableTreeNode)stack.pop();
                                    label = tmp.label;
                                    posTag = tmp.posTag;
                                    if (this.blacklist.contains(label)) break block14;
                                    if (tmp.children.size() != 0) break block15;
                                    if (!posTag.matches("WRB|WP")) break block16;
                                    if (!label.equals("Where")) break block17;
                                    tmp.addAnnotation("http://dbpedia.org/ontology/Place");
                                    break block14;
                                }
                                if (!label.equals("Who")) break block14;
                                tmp.addAnnotation("http://dbpedia.org/ontology/Agent");
                                break block14;
                            }
                            if (posTag.matches("NN(.)*")) {
                                if (posTag.matches("NNS") && tmp.lemma != null) {
                                    label = tmp.lemma;
                                }
                                if (this.classesIndex.search(label).size() > 0) {
                                    List uris = this.classesIndex.search(label);
                                    for (String resourceURL : uris) {
                                        tmp.addAnnotation(resourceURL);
                                    }
                                } else {
                                    this.log.error("Strange case that never should happen");
                                }
                            } else {
                                this.log.debug("Not annotated node: " + tmp);
                            }
                            break block14;
                        }
                        if (!posTag.matches("NN(.)*")) break block18;
                        if (posTag.matches("NNS") && tmp.lemma != null) {
                            label = tmp.lemma;
                        }
                        if (this.classesIndex.search(label).size() > 0 || this.propertiesIndex.search(label).size() > 0) {
                            List uris = this.classesIndex.search(label);
                            for (String resourceURL : uris) {
                                tmp.addAnnotation(resourceURL);
                            }
                            uris = this.propertiesIndex.search(label);
                            for (String resourceURL : uris) {
                                tmp.addAnnotation(resourceURL);
                            }
                        } else if (this.dboIndex.search(label).size() > 0) {
                            ArrayList uris = this.dboIndex.search(label);
                            for (String resourceURL : uris) {
                                tmp.addAnnotation(resourceURL);
                            }
                        } else {
                            this.log.debug("Not annotated node: " + tmp);
                        }
                        break block14;
                    }
                    if (!posTag.matches("WRB|WP")) break block19;
                    if (!label.equals("Where")) break block20;
                    tmp.addAnnotation("http://dbpedia.org/ontology/Place");
                    break block14;
                }
                if (!label.equals("Who")) break block14;
                tmp.addAnnotation("http://dbpedia.org/ontology/Agent");
                break block14;
            }
            this.log.error("Strange case that never should happen: " + posTag);
        }
    }
}

