/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.pruner.disjointness;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.util.HashSet;
import java.util.Set;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.pruner.ISPARQLQueryPruner;
import org.aksw.hawk.pruner.disjointness.QueryUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisjointnessBasedQueryFilter
implements ISPARQLQueryPruner {
    private static final ParameterizedSparqlString domainQueryTemplate = new ParameterizedSparqlString("PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#> SELECT ?dom WHERE {?p rdfs:domain ?o . ?o rdfs:subClassOf* ?dom .}");
    private static final ParameterizedSparqlString rangeQueryTemplate = new ParameterizedSparqlString("PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#> SELECT ?ran WHERE {?p rdfs:range ?o . ?o rdfs:subClassOf* ?ran .}");
    private static final ParameterizedSparqlString superClassesQueryTemplate = new ParameterizedSparqlString("PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#> SELECT ?sup WHERE {?sub rdfs:subClassOf+ ?sup .}");
    private static final Logger logger = LoggerFactory.getLogger(DisjointnessBasedQueryFilter.class);
    private QueryExecutionFactory qef;
    QueryUtils queryUtils = new QueryUtils();
    private static final Set<String> ignoredProperties = Sets.newHashSet((Object[])new String[]{"http://jena.apache.org/text#query", "http://dbpedia.org/ontology/abstract"});

    public DisjointnessBasedQueryFilter(QueryExecutionFactory qef) {
        this.qef = qef;
    }

    public Set<SPARQLQuery> prune(Set<SPARQLQuery> queryStrings, HAWKQuestion q) {
        MonitorFactory.getTimeMonitor((String)"parse").reset();
        HashSet filteredQueries = Sets.newHashSet();
        for (SPARQLQuery sparqlQuery : queryStrings) {
            if (!this.accept(sparqlQuery)) continue;
            filteredQueries.add(sparqlQuery);
        }
        System.err.println(MonitorFactory.getTimeMonitor((String)"parse"));
        return filteredQueries;
    }

    private Set<Node> getDomain(String predicate) {
        HashSet<Node> domains = new HashSet<Node>();
        domainQueryTemplate.setIri("p", predicate);
        String query = domainQueryTemplate.toString();
        QueryExecution qe = this.qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            domains.add(qs.getResource("dom").asNode());
        }
        qe.close();
        return domains;
    }

    private Set<Node> getRange(String predicate) {
        HashSet<Node> range = new HashSet<Node>();
        rangeQueryTemplate.setIri("p", predicate);
        String query = rangeQueryTemplate.toString();
        QueryExecution qe = this.qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            range.add(qs.getResource("ran").asNode());
        }
        qe.close();
        return range;
    }

    private Set<Node> getSuperClasses(String cls) {
        HashSet<Node> superClasses = new HashSet<Node>();
        superClassesQueryTemplate.setIri("sub", cls);
        String query = superClassesQueryTemplate.toString();
        QueryExecution qe = this.qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            superClasses.add(qs.getResource("sup").asNode());
        }
        qe.close();
        return superClasses;
    }

    private boolean accept(SPARQLQuery sparqlQuery) {
        Monitor mon = MonitorFactory.getTimeMonitor((String)"parse");
        mon.start();
        Query query = QueryFactory.create((String)sparqlQuery.toString());
        mon.stop();
        Set typeTriples = this.queryUtils.getRDFTypeTriples(query);
        HashMultimap var2Types = HashMultimap.create();
        for (Object triple : typeTriples) {
            if (!triple.getObject().isURI()) continue;
            Node type = triple.getObject();
            Var var = Var.alloc((Node)triple.getSubject());
            var2Types.put((Object)var, (Object)type);
            var2Types.putAll((Object)var, (Iterable)this.getSuperClasses(type.getURI()));
        }
        Set subjectVars = this.queryUtils.getSubjectVariables(query);
        for (Var var : subjectVars) {
            Set outgoingTriplePatterns = this.queryUtils.extractOutgoingTriplePatterns(query, (Node)var);
            outgoingTriplePatterns.removeAll(typeTriples);
            Set subjectTypes = (Set)var2Types.get((Object)var);
            if (subjectTypes.isEmpty()) continue;
            for (Triple tp : outgoingTriplePatterns) {
                Node predicate = tp.getPredicate();
                if (!predicate.isURI() || ignoredProperties.contains(predicate.toString())) continue;
                Set domain = this.getDomain(predicate.getURI());
                logger.debug("Domain of " + predicate + ": " + subjectTypes);
                if (!this.conflicts(subjectTypes, domain)) continue;
                logger.debug("Domain of " + predicate + " does not match types " + subjectTypes);
                return false;
            }
        }
        Set objectVars = this.queryUtils.getSubjectVariables(query);
        for (Var var : objectVars) {
            Set incomingTriplePatterns = this.queryUtils.extractIncomingTriplePatterns(query, (Node)var);
            Set objectTypes = (Set)var2Types.get((Object)var);
            if (objectTypes.isEmpty()) continue;
            for (Triple tp : incomingTriplePatterns) {
                Node predicate = tp.getPredicate();
                if (!predicate.isURI() || ignoredProperties.contains(predicate.toString())) continue;
                Set range = this.getRange(predicate.getURI());
                logger.debug("Range of " + predicate + ": " + objectTypes);
                if (!this.conflicts(objectTypes, range)) continue;
                logger.debug("Range of " + predicate + " does not match types " + objectTypes);
                return false;
            }
        }
        return true;
    }

    private boolean conflicts(Set<Node> types1, Set<Node> types2) {
        return Sets.intersection(types1, types2).isEmpty();
    }
}

