/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.pruner;

import com.google.common.collect.Sets;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.pruner.ISPARQLQueryPruner;
import org.aksw.hawk.pruner.disjointness.QueryUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMismatch
implements ISPARQLQueryPruner {
    private static final ParameterizedSparqlString typeQueryTemplate = new ParameterizedSparqlString("PREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#> SELECT ?type WHERE {?s a ?type .}");
    private static final Set<Resource> PROPERTY_ENTITY_TYPES = Sets.newHashSet((Object[])new Resource[]{OWL.ObjectProperty, OWL.DatatypeProperty, RDF.Property});
    private static final Logger logger = LoggerFactory.getLogger(TypeMismatch.class);
    private QueryExecutionFactory qef;
    private QueryUtils queryUtils = new QueryUtils();
    private Monitor mon = MonitorFactory.getTimeMonitor((String)"typeMismatch");
    private static final Set<String> ignoredProperties = Sets.newHashSet((Object[])new String[]{"http://jena.apache.org/text#query", "http://dbpedia.org/ontology/abstract"});

    public TypeMismatch(QueryExecutionFactory qef) {
        this.qef = qef;
    }

    public Set<SPARQLQuery> prune(Set<SPARQLQuery> queryStrings, HAWKQuestion q) {
        this.mon.reset();
        HashSet filteredQueries = Sets.newHashSet();
        for (SPARQLQuery sparqlQuery : queryStrings) {
            if (!this.accept(sparqlQuery)) continue;
            filteredQueries.add(sparqlQuery);
        }
        return filteredQueries;
    }

    private Set<Resource> getEntityTypes(String entity) {
        HashSet<Resource> entityTypes = new HashSet<Resource>();
        typeQueryTemplate.setIri("s", entity);
        String query = typeQueryTemplate.toString();
        QueryExecution qe = this.qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            Resource type = qs.getResource("type");
            entityTypes.add(type);
        }
        qe.close();
        return entityTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accept(SPARQLQuery sparqlQuery) {
        this.mon.start();
        try {
            Query query = QueryFactory.create((String)sparqlQuery.toString());
            List projectVars = query.getProjectVars();
            Set triplePatterns = this.queryUtils.extractTriplePattern(query);
            for (Triple tp : triplePatterns) {
                Node predicate = tp.getPredicate();
                if (!predicate.isURI() || predicate.getNameSpace().equals(RDF.getURI()) || predicate.getNameSpace().equals(RDFS.getURI()) || ignoredProperties.contains(predicate.getURI())) continue;
                Set entityTypes = this.getEntityTypes(predicate.getURI());
                if (!this.isProperty(entityTypes)) {
                    boolean bl = false;
                    return bl;
                }
                if (!entityTypes.contains(OWL.DatatypeProperty) || !projectVars.contains(tp.getObject())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mon.stop();
        }
        return true;
    }

    private boolean isProperty(Set<Resource> entityTypes) {
        return !Sets.intersection(entityTypes, (Set)PROPERTY_ENTITY_TYPES).isEmpty();
    }
}

