/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.number;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.hawk.controller.StanfordNLPConnector;
import org.aksw.hawk.number.IUnitLanguage;
import org.aksw.hawk.number.UnitEnglish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitController {
    private Map<String, IUnitLanguage> languageToHandler = new HashMap();
    private static Logger log = LoggerFactory.getLogger(UnitController.class);

    public String normalizeNumbers(String langDescriptor, String question) {
        if (this.languageToHandler.keySet().contains(langDescriptor)) {
            return ((IUnitLanguage)this.languageToHandler.get(langDescriptor)).convert(question);
        }
        log.debug("Failed to to normalize numbers and units - No implementation for given language");
        return question;
    }

    public Map<String, IUnitLanguage> getLanguageToHandler() {
        return this.languageToHandler;
    }

    public void setLanguageToHandler(Map<String, IUnitLanguage> languageToHandler) {
        this.languageToHandler = languageToHandler;
    }

    public void instantiateEnglish(StanfordNLPConnector stanford) {
        this.languageToHandler.put("en", new UnitEnglish(stanford));
    }

    public static List<List<String>> loadTabSplit(InputStream input) throws IOException {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input));
        String line = bufferedReader.readLine();
        while (line != null) {
            if (line.startsWith("//")) {
                line = bufferedReader.readLine();
                continue;
            }
            ret.add(new ArrayList<String>(Arrays.asList(line.split("\t"))));
            line = bufferedReader.readLine();
        }
        bufferedReader.close();
        return ret;
    }
}

