/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.nlp;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.nlp.MutableTree;
import org.aksw.hawk.nlp.MutableTreeNode;
import org.aksw.qa.commons.datastructure.Entity;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SentenceToSequence {
    static Logger log = LoggerFactory.getLogger(SentenceToSequence.class);

    public static void runPhraseCombination(HAWKQuestion q, List<String> tokens, Map<String, String> label2pos) {
        int tokenOffset = 0;
        int wordCounter = 0;
        ArrayList subsequence = Lists.newArrayList();
        for (int tcounter = 0; tcounter < tokens.size(); ++tcounter) {
            String lastPos;
            wordCounter += tokens.get(tcounter).split(" ").length;
            String token = tokens.get(tcounter);
            String pos = label2pos.get(token);
            String nextPos = tcounter + 1 == tokens.size() ? null : label2pos.get(tokens.get(tcounter + 1));
            String string = lastPos = tcounter == 0 ? null : label2pos.get(tokens.get(tcounter - 1));
            if (subsequence.isEmpty()) {
                tokenOffset = wordCounter;
            }
            if (subsequence.isEmpty() && null != pos && pos.matches("CD|JJ|NN(.)*|RB(.)*")) {
                subsequence.add(token);
                continue;
            }
            if (!subsequence.isEmpty() && null != pos && tcounter + 1 < tokens.size() && null != nextPos && pos.matches("IN") && !token.matches("of") && nextPos.matches("(W)?DT|NNP(S)?")) {
                if (subsequence.size() > 1) {
                    SentenceToSequence.transformTree((List)subsequence, (HAWKQuestion)q, (int)tokenOffset);
                }
                subsequence = Lists.newArrayList();
                continue;
            }
            if (!subsequence.isEmpty() && null != pos && null != lastPos && lastPos.matches("NNS") && pos.matches("NNP(S)?")) {
                if (subsequence.size() > 2) {
                    SentenceToSequence.transformTree((List)subsequence, (HAWKQuestion)q, (int)tokenOffset);
                }
                subsequence = Lists.newArrayList();
                continue;
            }
            if (!subsequence.isEmpty() && !lastPos.matches("JJ|HYPH") && (null == pos || pos.matches("VB(.)*|\\.|WDT") || pos.matches("IN") && nextPos == null || pos.matches("IN") && nextPos.matches("DT"))) {
                if (subsequence.size() > 1) {
                    SentenceToSequence.transformTree((List)subsequence, (HAWKQuestion)q, (int)tokenOffset);
                }
                subsequence = Lists.newArrayList();
                continue;
            }
            if (!subsequence.isEmpty() && null != pos && pos.matches("NN(.)*|RB|CD|CC|JJ|DT|IN|PRP|HYPH|VBN")) {
                subsequence.add(token);
                continue;
            }
            subsequence = Lists.newArrayList();
        }
        log.debug(q.getLanguageToNounPhrases().toString());
    }

    public static void transformTree(List<String> subsequence, HAWKQuestion q, int subsequenceStartOffset) {
        String combinedNN = Joiner.on((String)" ").join(subsequence);
        String combinedURI = "http://aksw.org/combinedNN/" + Joiner.on((String)"_").join(subsequence);
        Entity tmpEntity = new Entity();
        tmpEntity.setOffset(subsequenceStartOffset);
        tmpEntity.setLabel(combinedNN);
        tmpEntity.getUris().add(new ResourceImpl(combinedURI));
        List nounphrases = (List)q.getLanguageToNounPhrases().get("en");
        if (null == nounphrases) {
            nounphrases = Lists.newArrayList();
        }
        nounphrases.add(tmpEntity);
        q.getLanguageToNounPhrases().put("en", nounphrases);
    }

    public static void resolveCompoundNouns(MutableTree tree, List<Entity> list) {
        Stack<MutableTreeNode> stack = new Stack<MutableTreeNode>();
        stack.push(tree.getRoot());
        while (!stack.isEmpty()) {
            MutableTreeNode thisNode = (MutableTreeNode)stack.pop();
            String label = thisNode.label;
            if (label.contains("aksw.org")) {
                thisNode.label = Joiner.on((String)" ").join((Object[])label.replace("http://aksw.org/combinedNN/", "").split("_"));
                thisNode.posTag = "CombinedNN";
            }
            for (MutableTreeNode child : thisNode.getChildren()) {
                stack.push(child);
            }
        }
    }
}

