/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.nlp;

import java.util.Iterator;
import java.util.LinkedList;
import org.aksw.hawk.nlp.MutableTreeNode;

public class MutableTreeNodeIterator
implements Iterator<MutableTreeNode> {
    private MutableTreeNode root = null;
    private MutableTreeNode current = null;
    private LinkedList<Integer> path = new LinkedList();
    private int nodeTier = -1;
    private boolean hasNext = false;

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return this.current != null;
        }
        this.current = this.next();
        this.hasNext = true;
        return this.current != null;
    }

    public MutableTreeNodeIterator(MutableTreeNode root) {
        this.root = root;
    }

    @Override
    public MutableTreeNode next() {
        if (this.hasNext) {
            this.hasNext = false;
            return this.current;
        }
        this.hasNext = false;
        if (this.path.isEmpty()) {
            this.path.add(0);
            this.current = this.root;
            this.nodeTier = 0;
            return this.current;
        }
        if (this.nodeTier == this.path.size() - 1) {
            if (this.current.getChildren().size() > 0) {
                ++this.nodeTier;
                this.path.add(0);
                this.current = (MutableTreeNode)this.current.getChildren().get(0);
                return this.current;
            }
            --this.nodeTier;
            this.current = this.current.parent;
            return this.next();
        }
        int lastChild = (Integer)this.path.removeLast();
        if (lastChild + 1 < this.current.getChildren().size()) {
            ++this.nodeTier;
            this.current = (MutableTreeNode)this.current.getChildren().get(lastChild + 1);
            this.path.add(lastChild + 1);
            return this.current;
        }
        --this.nodeTier;
        if (this.nodeTier < 0) {
            return null;
        }
        this.current = this.current.parent;
        return this.next();
    }

    @Override
    public void remove() {
    }

    public int getTier() {
        return this.nodeTier;
    }

    public void reset() {
        this.current = null;
        this.path = new LinkedList();
        this.nodeTier = -1;
        this.hasNext = false;
    }
}

