/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.nlp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.aksw.hawk.nlp.MutableTreeNode;
import org.aksw.hawk.nlp.TreeTraversal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableTree
implements Serializable {
    private static final long serialVersionUID = 1286195006804443794L;
    static Logger log = LoggerFactory.getLogger(MutableTree.class);
    private MutableTreeNode root = null;

    public MutableTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(MutableTreeNode root) {
        this.root = root;
    }

    public boolean remove(MutableTreeNode target) {
        if (!this.getAllNodes().contains(target)) {
            return false;
        }
        if (target.equals(this.root)) {
            if (this.root.children.size() == 1) {
                this.root = (MutableTreeNode)this.root.children.get(0);
                return true;
            }
            log.error("More than one child on to be removed root. Need to rebalance tree or something.");
            return false;
        }
        List children = target.children;
        MutableTreeNode parent = target.parent;
        List parentsChildren = parent.children;
        parentsChildren.addAll(children);
        for (MutableTreeNode grandchild : children) {
            grandchild.parent = parent;
        }
        parentsChildren.remove(target);
        return true;
    }

    public String toString() {
        return TreeTraversal.inorderTraversal((MutableTreeNode)this.root, (int)0, null);
    }

    public MutableTree hardcopy() {
        MutableTree tree = new MutableTree();
        tree.root = this.root.hardcopy(null);
        return tree;
    }

    public List<MutableTreeNode> getAllNodesInSentenceOrder() {
        List<MutableTreeNode> inOrder = new Vector();
        inOrder = this.getAllNodes();
        if (inOrder.isEmpty()) {
            return inOrder;
        }
        Collections.sort(inOrder, new /* Unavailable Anonymous Inner Class!! */);
        return inOrder;
    }

    public List<MutableTreeNode> getAllNodes() {
        Vector<MutableTreeNode> allNodes = new Vector<MutableTreeNode>();
        if (this.root == null) {
            return allNodes;
        }
        return this.root.subNodes();
    }

    public Map<String, String> getPOSTags() {
        HashMap<String, String> tokenToPOS = new HashMap<String, String>();
        for (MutableTreeNode node : this.getAllNodes()) {
            tokenToPOS.put(node.getLabel(), node.getPosTag());
        }
        return tokenToPOS;
    }

    public void updateNodeNumbers() {
        List orderlyNodes = this.getAllNodes();
        Collections.sort(orderlyNodes);
        for (int i = 0; i < orderlyNodes.size(); ++i) {
            ((MutableTreeNode)orderlyNodes.get((int)i)).nodeNumber = i;
        }
    }

    public List<MutableTreeNode> getAllNodesWithDepth(int depth) {
        ArrayList<MutableTreeNode> sameDepth = new ArrayList<MutableTreeNode>();
        for (MutableTreeNode it : this.getAllNodes()) {
            if (it.getDepth() != depth) continue;
            sameDepth.add(it);
        }
        return sameDepth;
    }

    public List<MutableTreeNode> getPathToRoot(MutableTreeNode node) {
        ArrayList<MutableTreeNode> path = new ArrayList<MutableTreeNode>();
        MutableTreeNode current = node;
        do {
            current = current.parent;
            path.add(current);
        } while (current != this.root);
        return path;
    }
}

