/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Patty_relations {
    private static final Version LUCENE_VERSION = Version.LUCENE_46;
    private Logger log = LoggerFactory.getLogger(Patty_relations.class);
    private int numberOfDocsRetrievedFromIndex = 100;
    public String FIELD_NAME_URI = "uri";
    public String FIELD_NAME_OBJECT = "object";
    private Directory directory;
    private IndexSearcher isearcher;
    private DirectoryReader ireader;
    private IndexWriter iwriter;
    private StandardAnalyzer analyzer;

    public Patty_relations() {
        try {
            File indexDir = new File("resources/puttyRelations");
            this.analyzer = new StandardAnalyzer(LUCENE_VERSION);
            if (!indexDir.exists()) {
                indexDir.mkdir();
                IndexWriterConfig config = new IndexWriterConfig(LUCENE_VERSION, (Analyzer)this.analyzer);
                this.directory = new MMapDirectory(indexDir);
                this.iwriter = new IndexWriter(this.directory, config);
                this.index();
            } else {
                this.directory = new MMapDirectory(indexDir);
            }
            this.ireader = DirectoryReader.open((Directory)this.directory);
            this.isearcher = new IndexSearcher((IndexReader)this.ireader);
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void index() {
        try {
            Path currentDir = Paths.get(".", new String[0]);
            Path path = currentDir.resolve("resources/dbpedia-relation-paraphrases.txt");
            Stream<String> lines = Files.lines(path);
            lines.forEach(s -> this.lineSplitAndAddtoIndex(s));
            lines.close();
            this.iwriter.commit();
            this.iwriter.close();
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void addDocumentToIndex(String relation, String data) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StringField(this.FIELD_NAME_URI, "http://dbpedia.org/ontology/" + relation, Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_NAME_OBJECT, data, Field.Store.YES));
        this.iwriter.addDocument((Iterable)doc);
    }

    private void lineSplitAndAddtoIndex(String line) {
        String rel = line.split("\\t")[0];
        String dat = line.split("\\t")[1];
        try {
            this.addDocumentToIndex(rel, dat);
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public HashSet<String> search(String object) {
        ArrayList uris = Lists.newArrayList();
        try {
            this.log.debug("\t start asking index...");
            FuzzyQuery q = new FuzzyQuery(new Term(this.FIELD_NAME_OBJECT, object), 0);
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)this.numberOfDocsRetrievedFromIndex, (boolean)true);
            this.isearcher.search((Query)q, (Collector)collector);
            ScoreDoc[] hits = collector.topDocs().scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                Document hitDoc = this.isearcher.doc(hits[i].doc);
                uris.add(hitDoc.get(this.FIELD_NAME_URI));
            }
            this.log.debug("\t finished asking index...");
        }
        catch (Exception e) {
            this.log.error(e.getLocalizedMessage() + " -> " + object, (Throwable)e);
        }
        HashSet setUris = Sets.newHashSet((Iterable)uris);
        return setUris;
    }
}

