/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.experiment;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.hawk.controller.PipelineStanford;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.ranking.BucketRanker;
import org.aksw.hawk.ranking.OptimalRanker;
import org.aksw.hawk.ranking.TierRanker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleQuestionPipeline {
    static Logger log = LoggerFactory.getLogger(SingleQuestionPipeline.class);

    public static void main(String[] args) throws IOException, ParserConfigurationException {
        log.info("Configuring controller");
        PipelineStanford pipeline = new PipelineStanford();
        HAWKQuestion q = new HAWKQuestion();
        q.getLanguageToQuestion().put("en", "Who is the president of the United States?");
        log.info("Run pipeline on " + (String)q.getLanguageToQuestion().get("en"));
        List answers = pipeline.getAnswersToQuestion(q);
        log.info("Run ranking");
        int maximumPositionToMeasure = 10;
        OptimalRanker optimal_ranker = new OptimalRanker();
        BucketRanker bucket_ranker = new BucketRanker();
        TierRanker tier = new TierRanker();
        log.info("Optimal ranking not applicable (right now).");
        log.info("Bucket-based ranking");
        List rankedAnswer = bucket_ranker.rank(answers, q);
        log.info(Joiner.on((String)"\n\t").join((Iterable)rankedAnswer));
        log.info("Tier-based ranking");
        rankedAnswer = tier.rank(answers, q);
        log.info(Joiner.on((String)"\n\t").join((Iterable)rankedAnswer));
    }
}

