/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.experiment;

import java.util.ArrayList;
import java.util.List;
import org.aksw.hawk.controller.StanfordNLPConnector;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.datastructures.HAWKQuestionFactory;
import org.aksw.hawk.nouncombination.NounCombinationChain;
import org.aksw.hawk.nouncombination.NounCombiners;
import org.aksw.qa.annotation.spotter.Spotlight;
import org.aksw.qa.commons.datastructure.Entity;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.jena.ext.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NounPhraseIdentification {
    static Logger log = LoggerFactory.getLogger(NounPhraseIdentification.class);

    public static void main(String[] args) {
        StanfordNLPConnector connector = new StanfordNLPConnector();
        Spotlight nerdModule = new Spotlight();
        List loadedQuestions = LoaderController.load((Dataset)Dataset.QALD6_Train_Hybrid);
        List questionsStanford = HAWKQuestionFactory.createInstances((List)loadedQuestions);
        NounCombinationChain hawk = new NounCombinationChain(NounCombiners.HawkRules, new NounCombiners[0]);
        NounCombinationChain stanf = new NounCombinationChain(NounCombiners.StanfordDependecy, new NounCombiners[0]);
        NounCombinationChain hawkStanf = new NounCombinationChain(NounCombiners.HawkRules, new NounCombiners[]{NounCombiners.StanfordDependecy});
        NounCombinationChain stanfHawk = new NounCombinationChain(NounCombiners.StanfordDependecy, new NounCombiners[]{NounCombiners.HawkRules});
        for (HAWKQuestion currentQuestion : questionsStanford) {
            String s = "Which birds are protected under the National Parks and Wildlife Act?";
            if (!((String)currentQuestion.getLanguageToQuestion().get("en")).equals(s)) continue;
            log.info((String)currentQuestion.getLanguageToQuestion().get("en"));
            currentQuestion.setLanguageToNamedEntites(nerdModule.getEntities((String)currentQuestion.getLanguageToQuestion().get("en")));
            connector.parseTree(currentQuestion, null);
            System.out.println(currentQuestion.getTree().toString());
            ArrayList<ImmutablePair> annoQuestions = new ArrayList<ImmutablePair>();
            HAWKQuestion qHawk = hawk.runChainReturnNew(currentQuestion);
            annoQuestions.add(new ImmutablePair((Object)"OwnRules:      ", (Object)qHawk));
            HAWKQuestion qStanf = stanf.runChainReturnNew(currentQuestion);
            annoQuestions.add(new ImmutablePair((Object)"Stanford:      ", (Object)qStanf));
            HAWKQuestion qHawkStanf = hawkStanf.runChainReturnNew(currentQuestion);
            annoQuestions.add(new ImmutablePair((Object)"1.Own 2.Stanf: ", (Object)qHawkStanf));
            HAWKQuestion qStanfHawk = stanfHawk.runChainReturnNew(currentQuestion);
            annoQuestions.add(new ImmutablePair((Object)"1.Stanf 2.Own  ", (Object)qStanfHawk));
            for (ImmutablePair it : annoQuestions) {
                if (((HAWKQuestion)it.getRight()).getLanguageToNounPhrases().get("en") == null || ((List)((HAWKQuestion)it.getRight()).getLanguageToNounPhrases().get("en")).isEmpty()) continue;
                ArrayList<String> nouns = new ArrayList<String>();
                for (Entity entity : (List)((HAWKQuestion)it.getRight()).getLanguageToNounPhrases().get("en")) {
                    nouns.add(entity.getLabel());
                }
                log.info((String)it.getLeft() + "[" + Joiner.on((String)", ").join(nouns) + "]");
            }
            log.info("\n");
        }
    }
}

