/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.experiment;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.datastructures.HAWKQuestionFactory;
import org.aksw.hawk.experiment.IndexComparer;
import org.aksw.hawk.index.DBOIndex;
import org.aksw.hawk.index.Patty_relations;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndexComparer {
    static Logger log = LoggerFactory.getLogger(IndexComparer.class);
    static Patty_relations pattyindex = new Patty_relations();
    static DBOIndex dboindex = new DBOIndex();

    public static void main(String[] args) {
        List questions = IndexComparer.getQALDQuestions();
        ArrayList<List> questionsWithSetsToCompare = new ArrayList<List>();
        for (HAWKQuestion hAWKQuestion : questions) {
            List setsToCompare = IndexComparer.getSets((HAWKQuestion)hAWKQuestion);
            questionsWithSetsToCompare.add(setsToCompare);
        }
        for (List list : questionsWithSetsToCompare) {
            String question = ((HashSet)list.get(0)).toString();
            HashSet relevantDocs = (HashSet)list.get(1);
            HashSet pattyRetrievedDocs = (HashSet)list.get(2);
            HashSet pattyIntersection = new HashSet((Collection)list.get(1));
            pattyIntersection.retainAll((Collection)list.get(2));
            double pattyPrecision = (double)pattyIntersection.size() / (double)pattyRetrievedDocs.size();
            double pattyRecall = (double)pattyIntersection.size() / (double)relevantDocs.size();
            HashSet dboRetrievedDocs = (HashSet)list.get(3);
            HashSet dboIntersection = new HashSet((Collection)list.get(1));
            pattyIntersection.retainAll((Collection)list.get(3));
            double dboPrecision = (double)dboIntersection.size() / (double)dboRetrievedDocs.size();
            double dboRecall = (double)dboIntersection.size() / (double)relevantDocs.size();
            System.out.println(question + " relevant URIs: " + relevantDocs.toString());
            System.out.println("\nPattyRelations\nprecision: " + pattyPrecision + "\nrecall: " + pattyRecall);
            System.out.println("\nDBOIndex\nprecision: " + dboPrecision + "\nrecall: " + dboRecall + "\n");
        }
    }

    private static List<HAWKQuestion> getQALDQuestions() {
        log.info("Loading dataset");
        List questions = null;
        questions = HAWKQuestionFactory.createInstances((List)LoaderController.load((Dataset)Dataset.QALD6_Train_Multilingual));
        return questions;
    }

    private static HashSet<String> getURISet(String question, String index) {
        HashSet<String> result = new HashSet<String>();
        for (String term : question.split(" ")) {
            if (index.equals("pattyindex")) {
                result.addAll(pattyindex.search(term));
                continue;
            }
            if (!index.equals("dboindex")) continue;
            result.addAll(dboindex.search(term));
        }
        return result;
    }

    private static HashSet<String> getSparql(HAWKQuestion q) {
        String sparqlQuerystring = q.getSparqlQuery();
        if (sparqlQuerystring == null) {
            return Sets.newHashSet();
        }
        Query sparqlQuery = QueryFactory.create((String)sparqlQuerystring);
        HashSet<String> predicates = new HashSet<String>();
        1 ELB = new /* Unavailable Anonymous Inner Class!! */;
        ElementWalker.walk((Element)sparqlQuery.getQueryPattern(), (ElementVisitor)ELB);
        return predicates;
    }

    private static List<HashSet<String>> getSets(HAWKQuestion q) {
        String question = ((String)q.getLanguageToQuestion().get("en")).replaceAll("\\p{P}", "");
        HashSet uriBucketPatty = IndexComparer.getURISet((String)question, (String)"pattyindex");
        HashSet uriBucketDBO = IndexComparer.getURISet((String)question, (String)"dboindex");
        HashSet uriSparql = IndexComparer.getSparql((HAWKQuestion)q);
        ArrayList<HashSet<String>> comparison = new ArrayList<HashSet<String>>();
        comparison.add(Sets.newHashSet((Object[])new String[]{question}));
        comparison.add(uriSparql);
        comparison.add(uriBucketPatty);
        comparison.add(uriBucketDBO);
        return comparison;
    }
}

