/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.hawk.controller;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLPClient;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aksw.hawk.controller.HAWKUtils;
import org.aksw.hawk.datastructures.HAWKQuestion;
import org.aksw.hawk.nlp.MutableTree;
import org.aksw.hawk.nlp.MutableTreeNode;
import org.aksw.hawk.number.UnitController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StanfordNLPConnector {
    private StanfordCoreNLPClient stanfordPipe;
    private int nodeNumber;
    private Set<IndexedWord> visitedNodes;
    public static StringBuilder out = new StringBuilder();
    private static Logger log = LoggerFactory.getLogger(StanfordNLPConnector.class);
    private static final String STANFORD_IP = "139.18.2.164";
    private static final int STANFORD_PORT = 9000;
    private static final int USED_CORES = 4;

    public StanfordNLPConnector(String annotators) {
        Properties props = new Properties();
        props.setProperty("annotators", annotators);
        this.stanfordPipe = new StanfordCoreNLPClient(props, STANFORD_IP, 9000, 4);
    }

    public StanfordNLPConnector() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos,lemma, ner,parse");
        this.stanfordPipe = new StanfordCoreNLPClient(props, STANFORD_IP, 9000, 4);
    }

    public Annotation runAnnotation(String s) {
        Annotation annotationDocument = new Annotation(this.preprocessStringForStanford(s));
        this.stanfordPipe.annotate(annotationDocument);
        return annotationDocument;
    }

    public Annotation runAnnotation(HAWKQuestion q) {
        String s = this.preprocessStringForStanford((String)q.getLanguageToQuestion().get("en"));
        Annotation annotationDocument = new Annotation(s);
        this.stanfordPipe.annotate(annotationDocument);
        return annotationDocument;
    }

    public MutableTree process(Annotation document) {
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        CoreMap sen = (CoreMap)sentences.get(0);
        SemanticGraph graph = (SemanticGraph)sen.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
        MutableTree tree = this.semanticGraphToMutableTree(graph, null);
        return tree;
    }

    public MutableTree parseTree(HAWKQuestion q, UnitController numberToDigit) {
        String sentence = HAWKUtils.replaceNamedEntitysWithURL((HAWKQuestion)q);
        log.info(sentence);
        if (numberToDigit != null) {
            sentence = numberToDigit.normalizeNumbers("en", sentence);
            log.info(sentence);
        }
        Annotation document = this.runAnnotation(this.preprocessStringForStanford(sentence));
        MutableTree tree = this.process(document);
        q.setTree(tree);
        return tree;
    }

    public Map<String, String> generatePOSTags(Annotation document) {
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        CoreMap sen = (CoreMap)sentences.get(0);
        LinkedList<String> tokens = new LinkedList<String>();
        HashMap<String, String> label2pos = new HashMap<String, String>();
        for (CoreLabel token : (List)sen.get(CoreAnnotations.TokensAnnotation.class)) {
            String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
            String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            tokens.add(word);
            label2pos.put(word, pos);
        }
        return label2pos;
    }

    private MutableTree semanticGraphToMutableTree(SemanticGraph graph, HAWKQuestion q) {
        log.debug(graph.toString());
        this.nodeNumber = 0;
        MutableTree tree = new MutableTree();
        this.visitedNodes = new HashSet();
        IndexedWord graphRoot = graph.getFirstRoot();
        MutableTreeNode mutableRoot = new MutableTreeNode(this.postprocessStringForStanford(graphRoot), graphRoot.tag(), "root", null, this.nodeNumber++, graphRoot.lemma(), ((Integer)graphRoot.get(CoreAnnotations.IndexAnnotation.class)).intValue());
        tree.setRoot(mutableRoot);
        this.convertGraphStanford(mutableRoot, graphRoot, graph);
        return tree;
    }

    public String preprocessStringForStanford(String input) {
        try {
            return input.replaceAll("[()]", "////");
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
    }

    public String postprocessStringForStanford(IndexedWord node) {
        return node.word().replaceAll("(////)(.+)(////)", "($2)");
    }

    private void convertGraphStanford(MutableTreeNode parentMutableNode, IndexedWord parentGraphWord, SemanticGraph graph) {
        this.visitedNodes.add(parentGraphWord);
        parentGraphWord.setWord(this.postprocessStringForStanford(parentGraphWord));
        if (parentGraphWord.word().contains("http://dbpedia.org/resource/")) {
            parentMutableNode.posTag = "ADD";
        }
        HashSet notCyclicChildren = new HashSet(graph.getChildren(parentGraphWord));
        notCyclicChildren.removeAll(this.visitedNodes);
        if (notCyclicChildren.isEmpty()) {
            return;
        }
        for (IndexedWord child : notCyclicChildren) {
            SemanticGraphEdge edge = graph.getEdge(parentGraphWord, child);
            String depLabel = edge.getRelation().getShortName();
            int wordPos = (Integer)child.get(CoreAnnotations.IndexAnnotation.class);
            MutableTreeNode childMutableNode = new MutableTreeNode(child.word(), child.tag(), depLabel, parentMutableNode, this.nodeNumber++, child.lemma(), wordPos);
            parentMutableNode.addChild(childMutableNode);
            this.convertGraphStanford(childMutableNode, child, graph);
        }
    }

    public static String getStanfordIp() {
        return STANFORD_IP;
    }

    public static int getStanfordPort() {
        return 9000;
    }
}

