/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.sparql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SPARQLQuery
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6652694466896208327L;
    private static HashSet<String> stopwords = Sets.newHashSet((Object[])new String[]{"of", "is", "and", "in", "name", "was", "did", "person", "location", "organization"});
    public List<String> constraintTriples = Lists.newArrayList();
    public Set<String> filter = Sets.newHashSet();
    public Map<String, Set<String>> textMapFromVariableToSingleFuzzyToken = Maps.newHashMap();
    public Map<String, Set<String>> textMapFromVariableToCombinedNNExactMatchToken = Maps.newHashMap();
    private boolean isASKQuery = false;
    private int limit = 1;

    public SPARQLQuery(String initialConstraint) {
        this.constraintTriples.add(initialConstraint);
    }

    public SPARQLQuery() {
    }

    public void isASKQuery(boolean isASKQuery) {
        this.isASKQuery = isASKQuery;
    }

    public void addConstraint(String constraint) {
        this.constraintTriples.add(constraint);
    }

    public void addFilterOverAbstractsContraint(String variable, String label) {
        this.fuzzyToken(variable, label);
        this.exactToken(variable, label);
    }

    private void exactToken(String variable, String label) {
        if (this.textMapFromVariableToCombinedNNExactMatchToken.containsKey(variable)) {
            Set<String> set = this.textMapFromVariableToCombinedNNExactMatchToken.get(variable);
            set.add(label);
            this.textMapFromVariableToCombinedNNExactMatchToken.put(variable, set);
        } else {
            this.textMapFromVariableToCombinedNNExactMatchToken.put(variable, Sets.newHashSet((Object[])new String[]{label}));
        }
    }

    private void fuzzyToken(String variable, String label) {
        String[] separatedLabel = label.split("[ \\-]");
        if (this.textMapFromVariableToSingleFuzzyToken.containsKey(variable)) {
            Set<String> set = this.textMapFromVariableToSingleFuzzyToken.get(variable);
            for (String item : separatedLabel) {
                if (item.isEmpty()) continue;
                set.add(item);
            }
            this.textMapFromVariableToSingleFuzzyToken.put(variable, set);
        } else {
            HashSet set = Sets.newHashSet();
            for (String item : separatedLabel) {
                if (item.isEmpty()) continue;
                set.add(item);
            }
            this.textMapFromVariableToSingleFuzzyToken.put(variable, set);
        }
    }

    public boolean constraintsContains(String target) {
        for (String c : this.constraintTriples) {
            if (!c.contains(target)) continue;
            return true;
        }
        return false;
    }

    public void addFilter(String string) {
        this.filter.add(string);
    }

    public Object clone() throws CloneNotSupportedException {
        HashSet list;
        SPARQLQuery q = new SPARQLQuery();
        q.isASKQuery(this.isASKQuery);
        q.constraintTriples = Lists.newArrayList();
        for (String constraint : this.constraintTriples) {
            q.constraintTriples.add(constraint);
        }
        q.filter = Sets.newHashSet();
        for (String key : this.filter) {
            q.filter.add(key);
        }
        q.textMapFromVariableToSingleFuzzyToken = Maps.newHashMap();
        for (String key : this.textMapFromVariableToSingleFuzzyToken.keySet()) {
            list = Sets.newHashSet((Iterable)this.textMapFromVariableToSingleFuzzyToken.get(key));
            q.textMapFromVariableToSingleFuzzyToken.put(key, list);
        }
        q.textMapFromVariableToCombinedNNExactMatchToken = Maps.newHashMap();
        for (String key : this.textMapFromVariableToCombinedNNExactMatchToken.keySet()) {
            list = Sets.newHashSet((Iterable)this.textMapFromVariableToCombinedNNExactMatchToken.get(key));
            q.textMapFromVariableToCombinedNNExactMatchToken.put(key, list);
        }
        return q;
    }

    public String toString() {
        return this.generateQueryStringWithExactMatch();
    }

    public Set<String> generateQueries() {
        HashSet set = Sets.newHashSet();
        if (!this.textMapFromVariableToSingleFuzzyToken.isEmpty()) {
            String fuzzyQuery = this.generateQueryStringWithFuzzy();
            set.add(fuzzyQuery);
        }
        if (!this.textMapFromVariableToCombinedNNExactMatchToken.isEmpty()) {
            String exactQuery = this.generateQueryStringWithExactMatch();
            set.add(exactQuery);
        }
        return set;
    }

    private String generateQueryStringWithExactMatch() {
        StringBuilder sb = new StringBuilder();
        sb.append("PREFIX text:<http://jena.apache.org/text#> \n");
        if (this.isASKQuery) {
            sb.append("ASK {\n ");
        } else {
            sb.append("SELECT DISTINCT ?proj WHERE {\n ");
        }
        for (String variable : this.textMapFromVariableToCombinedNNExactMatchToken.keySet()) {
            ArrayList list = Lists.newArrayList((Iterable)this.textMapFromVariableToCombinedNNExactMatchToken.get(variable));
            if (list.isEmpty()) continue;
            sb.append(variable + " text:query (<http://dbpedia.org/ontology/abstract> '");
            StringBuilder fulltext = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0 && fulltext.length() > 0) {
                    fulltext.append(" AND ");
                }
                fulltext.append("\"" + (String)list.get(i) + "\"");
            }
            sb.append(fulltext.toString());
            sb.append("' 1000). \n");
        }
        for (String constraint : this.constraintTriples) {
            sb.append(constraint + " \n");
        }
        for (String filterString : this.filter) {
            sb.append("FILTER (" + filterString + ").\n ");
        }
        sb.append("}\n");
        if (!this.isASKQuery) {
            sb.append("LIMIT " + this.limit);
        }
        return sb.toString();
    }

    private String generateQueryStringWithFuzzy() {
        StringBuilder sb = new StringBuilder();
        sb.append("PREFIX text:<http://jena.apache.org/text#> \n");
        if (this.isASKQuery) {
            sb.append("ASK {\n ");
        } else {
            sb.append("SELECT DISTINCT ?proj WHERE {\n ");
        }
        for (String variable : this.textMapFromVariableToSingleFuzzyToken.keySet()) {
            ArrayList list = Lists.newArrayList((Iterable)this.textMapFromVariableToSingleFuzzyToken.get(variable));
            list.removeAll(stopwords);
            if (list.isEmpty()) continue;
            sb.append(variable + " text:query (<http://dbpedia.org/ontology/abstract> '");
            StringBuilder fulltext = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0 && fulltext.length() > 0) {
                    fulltext.append(" AND ");
                }
                if (this.isInteger((String)list.get(i))) {
                    fulltext.append((String)list.get(i));
                    continue;
                }
                fulltext.append((String)list.get(i) + "~1");
            }
            sb.append(fulltext.toString());
            sb.append("' 1000). \n");
        }
        for (String constraint : this.constraintTriples) {
            sb.append(constraint + " \n");
        }
        for (String filterString : this.filter) {
            sb.append("FILTER (" + filterString + ").\n ");
        }
        sb.append("}\n");
        if (!this.isASKQuery) {
            sb.append("LIMIT " + this.limit);
        }
        return sb.toString();
    }

    private boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c <= '/' || c >= ':') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setLimit(int cardinality) {
        this.limit = cardinality;
    }
}

