/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.sparql;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.h2.CacheUtilsH2;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.qa.commons.qald.QALD4_EvaluationUtils;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQL {
    Logger log = LoggerFactory.getLogger(SPARQL.class);
    public QueryExecutionFactory qef;
    public static final String ENDPOINT_TITAN = "http://139.18.2.164:3030/ds/sparql";
    public static final String ENDPOINT_DBPEIDA_ORG = "http://dbpedia.org/sparql";
    public static final String ENDPOINT_WIKIDATA_ORG = "http://query.wikidata.org/sparql";
    public static final String ENDPOINT_WIKIDATA_METAPHACTS = "https://wikidata.metaphacts.com/sparql";
    private long timeToLive = 31104000000L;

    public SPARQL() {
        try {
            CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend((String)"./sparql", (boolean)true, (long)this.timeToLive);
            this.qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)ENDPOINT_TITAN, (String[])new String[0]).config().withCache(cacheFrontend).end()).create();
        }
        catch (RuntimeException e) {
            this.log.error("Could not create SPARQL interface! ", (Throwable)e);
        }
    }

    public SPARQL(String endpoint) {
        try {
            CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend((String)"./sparql", (boolean)true, (long)this.timeToLive);
            this.qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)endpoint, (String[])new String[0]).config().withCache(cacheFrontend).end()).create();
        }
        catch (RuntimeException e) {
            this.log.error("Could not create SPARQL interface! ", (Throwable)e);
        }
    }

    public Set<RDFNode> sparql(String query) {
        HashSet set = Sets.newHashSet();
        try {
            QueryExecution qe = this.qef.createQueryExecution(query);
            if (qe != null && query.toString() != null) {
                if (QALD4_EvaluationUtils.isAskType(query)) {
                    set.add(new ResourceImpl(String.valueOf(qe.execAsk())));
                } else {
                    ResultSet results = qe.execSelect();
                    String firstVarName = (String)results.getResultVars().get(0);
                    while (results.hasNext()) {
                        RDFNode node = results.next().get(firstVarName);
                        if (node == null) continue;
                        set.add(node);
                    }
                }
                qe.close();
            }
        }
        catch (Exception e) {
            this.log.error(query.toString(), (Throwable)e);
        }
        return set;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public static void main(String[] args) {
        SPARQL sqb = new SPARQL();
        SPARQLQuery query = new SPARQLQuery();
        query.addConstraint("?proj a <http://dbpedia.org/ontology/Person>.");
        for (String q : query.generateQueries()) {
            Set<RDFNode> set = sqb.sparql(q);
            for (RDFNode item : set) {
                System.out.println(item);
            }
        }
    }
}

