/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.ListUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.util.VarUtils;

public class TriplePatternExtractor
extends ElementVisitorBase {
    private Set<Triple> triplePattern;
    private Set<Triple> optionalTriplePattern;
    private boolean inOptionalClause = false;
    private int unionCount = 0;
    private int optionalCount = 0;
    private int filterCount = 0;

    public Set<Triple> extractOutgoingTriplePatterns(Query query, Node node) {
        Set<Triple> triplePatterns = this.extractTriplePattern(query, false);
        Iterator<Triple> iterator = triplePatterns.iterator();
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            if (triple.subjectMatches(node)) continue;
            iterator.remove();
        }
        return triplePatterns;
    }

    public Set<Triple> extractIncomingTriplePatterns(Query query, Node node) {
        Set<Triple> triplePatterns = this.extractTriplePattern(query, false);
        Iterator<Triple> iterator = triplePatterns.iterator();
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            if (triple.objectMatches(node)) continue;
            iterator.remove();
        }
        return triplePatterns;
    }

    public Set<Triple> extractIngoingTriplePatterns(Query query, Node node) {
        Set<Triple> triplePatterns = this.extractTriplePattern(query, false);
        Iterator<Triple> iterator = triplePatterns.iterator();
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            if (triple.objectMatches(node)) continue;
            iterator.remove();
        }
        return triplePatterns;
    }

    public Set<Triple> extractTriplePatterns(Query query, Node node) {
        HashSet<Triple> triplePatterns = new HashSet<Triple>();
        triplePatterns.addAll(this.extractIngoingTriplePatterns(query, node));
        triplePatterns.addAll(this.extractOutgoingTriplePatterns(query, node));
        return triplePatterns;
    }

    public Set<Triple> extractNonOptionalTriplePatterns(Query query, Node node) {
        HashSet<Triple> triplePatterns = new HashSet<Triple>();
        triplePatterns.addAll(this.extractIngoingTriplePatterns(query, node));
        triplePatterns.addAll(this.extractOutgoingTriplePatterns(query, node));
        triplePatterns.removeAll(this.optionalTriplePattern);
        return triplePatterns;
    }

    public Map<Var, Set<Triple>> extractTriplePatternsForProjectionVars(Query query) {
        HashMap<Var, Set<Triple>> var2TriplePatterns = new HashMap<Var, Set<Triple>>();
        for (Var var : query.getProjectVars()) {
            HashSet<Triple> triplePatterns = new HashSet<Triple>();
            triplePatterns.addAll(this.extractIngoingTriplePatterns(query, (Node)var));
            triplePatterns.addAll(this.extractOutgoingTriplePatterns(query, (Node)var));
            var2TriplePatterns.put(var, triplePatterns);
        }
        return var2TriplePatterns;
    }

    public Map<Var, Set<Triple>> extractOutgoingTriplePatternsForProjectionVars(Query query) {
        HashMap<Var, Set<Triple>> var2TriplePatterns = new HashMap<Var, Set<Triple>>();
        for (Var var : query.getProjectVars()) {
            HashSet<Triple> triplePatterns = new HashSet<Triple>();
            triplePatterns.addAll(this.extractOutgoingTriplePatterns(query, (Node)var));
            var2TriplePatterns.put(var, triplePatterns);
        }
        return var2TriplePatterns;
    }

    public Set<Triple> getOptionalTriplePatterns() {
        return this.optionalTriplePattern;
    }

    public Map<Var, Set<Triple>> extractIncomingTriplePatternsForProjectionVars(Query query) {
        HashMap<Var, Set<Triple>> var2TriplePatterns = new HashMap<Var, Set<Triple>>();
        for (Var var : query.getProjectVars()) {
            HashSet<Triple> triplePatterns = new HashSet<Triple>();
            triplePatterns.addAll(this.extractIncomingTriplePatterns(query, (Node)var));
            var2TriplePatterns.put(var, triplePatterns);
        }
        return var2TriplePatterns;
    }

    public Map<Var, Set<Triple>> extractIngoingTriplePatternsForProjectionVars(Query query) {
        HashMap<Var, Set<Triple>> var2TriplePatterns = new HashMap<Var, Set<Triple>>();
        for (Var var : query.getProjectVars()) {
            HashSet<Triple> triplePatterns = new HashSet<Triple>();
            triplePatterns.addAll(this.extractIngoingTriplePatterns(query, (Node)var));
            var2TriplePatterns.put(var, triplePatterns);
        }
        return var2TriplePatterns;
    }

    public Set<Triple> extractTriplePattern(Query query) {
        return this.extractTriplePattern(query, false);
    }

    public Set<Triple> extractTriplePattern(Query query, boolean ignoreOptionals) {
        this.triplePattern = new HashSet<Triple>();
        this.optionalTriplePattern = new HashSet<Triple>();
        query.getQueryPattern().visit((ElementVisitor)this);
        if (!ignoreOptionals && query.isSelectType()) {
            for (Triple t : this.optionalTriplePattern) {
                if (ListUtils.intersection(new ArrayList(VarUtils.getVars((Triple)t)), (List)query.getProjectVars()).isEmpty()) continue;
                this.triplePattern.add(t);
            }
        }
        return this.triplePattern;
    }

    public boolean isOptional(Triple triple) {
        return this.optionalTriplePattern.contains(triple);
    }

    public Set<Triple> extractTriplePattern(ElementGroup group) {
        return this.extractTriplePattern(group, false);
    }

    public Set<Triple> extractTriplePattern(ElementGroup group, boolean ignoreOptionals) {
        this.triplePattern = new HashSet<Triple>();
        this.optionalTriplePattern = new HashSet<Triple>();
        group.visit((ElementVisitor)this);
        if (!ignoreOptionals) {
            for (Triple t : this.optionalTriplePattern) {
                this.triplePattern.add(t);
            }
        }
        return this.triplePattern;
    }

    public void visit(ElementGroup el) {
        for (Element e : el.getElements()) {
            e.visit((ElementVisitor)this);
        }
    }

    public void visit(ElementOptional el) {
        ++this.optionalCount;
        this.inOptionalClause = true;
        el.getOptionalElement().visit((ElementVisitor)this);
        this.inOptionalClause = false;
    }

    public void visit(ElementTriplesBlock el) {
        Iterator iterator = el.patternElts();
        while (iterator.hasNext()) {
            Triple t = (Triple)iterator.next();
            if (this.inOptionalClause) {
                this.optionalTriplePattern.add(t);
                continue;
            }
            this.triplePattern.add(t);
        }
    }

    public void visit(ElementPathBlock el) {
        Iterator iterator = el.patternElts();
        while (iterator.hasNext()) {
            TriplePath tp = (TriplePath)iterator.next();
            if (this.inOptionalClause) {
                this.optionalTriplePattern.add(tp.asTriple());
                continue;
            }
            if (!tp.isTriple()) continue;
            this.triplePattern.add(tp.asTriple());
        }
    }

    public void visit(ElementUnion el) {
        ++this.unionCount;
        for (Element e : el.getElements()) {
            e.visit((ElementVisitor)this);
        }
    }

    public void visit(ElementFilter el) {
        ++this.filterCount;
    }

    public int getUnionCount() {
        return this.unionCount;
    }

    public int getOptionalCount() {
        return this.optionalCount;
    }

    public int getFilterCount() {
        return this.filterCount;
    }

    public static void main(String[] args) throws Exception {
        Query q = QueryFactory.create((String)"prefix  dbp:  <http://dbpedia.org/resource/> prefix  dbp2: <http://dbpedia.org/ontology/> select  ?thumbnail where  { dbp:total !dbp2:thumbnail ?thumbnail }");
        TriplePatternExtractor triplePatternExtractor = new TriplePatternExtractor();
        triplePatternExtractor.extractIngoingTriplePatterns(q, (Node)q.getProjectVars().get(0));
    }
}

