/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.sparql;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aksw.qa.commons.sparql.SPARQL;
import org.apache.jena.rdf.model.RDFNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedSPARQL
extends SPARQL {
    private int timeoutInSeconds = 10;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ExecutorService executor = Executors.newFixedThreadPool(1);

    public ThreadedSPARQL() {
    }

    public ThreadedSPARQL(String endpoint) {
        super(endpoint);
    }

    public ThreadedSPARQL(int timeoutInSeconds, String endpoint) {
        super(endpoint);
        if (timeoutInSeconds > 0) {
            this.timeoutInSeconds = timeoutInSeconds;
        }
    }

    @Override
    public synchronized Set<RDFNode> sparql(String query) {
        Callable<Set> task = () -> {
            Date dateStart = new Date();
            Set<RDFNode> result = super.sparql(query);
            double executionTimeInS = ((double)new Date().getTime() - (double)dateStart.getTime()) / 1000.0;
            DecimalFormat df = new DecimalFormat("00.000");
            this.log.debug("Sparql response time: " + df.format(executionTimeInS) + "s");
            return result;
        };
        Future<Set> future = this.executor.submit(task);
        Set result = null;
        try {
            result = future.get(this.timeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        future.cancel(true);
        return result;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        if (timeoutInSeconds > 0) {
            this.timeoutInSeconds = timeoutInSeconds;
        }
    }

    public void destroy() {
        this.executor.shutdown();
    }
}

