/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.sparql;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.PrefixMapping2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLPrefixResolver {
    private static Logger LOGGER = LoggerFactory.getLogger(SPARQLPrefixResolver.class);
    private static Properties globalPrefixes = new Properties();
    private static PrefixMapping globalPrefixMapping;

    public static PrefixMapping getGlobalPrefixMapping() {
        return globalPrefixMapping;
    }

    public static String addMissingPrefixes(String sparqlQuery) {
        TwoStagePrefixMapping pmap = new TwoStagePrefixMapping(globalPrefixMapping);
        Query q1 = QueryFactory.create();
        q1.setPrefixMapping((PrefixMapping)pmap);
        q1 = QueryFactory.parse((Query)q1, (String)sparqlQuery, null, null);
        q1.toString();
        return q1.toString();
    }

    static {
        try {
            globalPrefixes.load(SPARQLPrefixResolver.class.getClassLoader().getResourceAsStream("prefixes.properties"));
            globalPrefixMapping = new PrefixMappingImpl();
            if (globalPrefixes != null) {
                globalPrefixMapping.setNsPrefixes((Map)globalPrefixes);
            }
            LOGGER.debug("Loaded prefixes.properties. Key count: " + globalPrefixes.size());
        }
        catch (IOException e) {
            LOGGER.error("Couldn't find resource file: prefixes.properties", (Throwable)e);
        }
    }

    static class TwoStagePrefixMapping
    extends PrefixMapping2 {
        private static Method checkValidPrefixMethod;

        public TwoStagePrefixMapping(PrefixMapping globalPrefixes) {
            super(globalPrefixes);
        }

        public String getNsPrefixURI(String prefix) {
            String s = super.getLocalPrefixMapping().getNsPrefixURI(prefix);
            if (s != null) {
                return s;
            }
            PrefixMapping pmapGlobal = super.getGlobalPrefixMapping();
            s = pmapGlobal.getNsPrefixURI(prefix);
            if (s != null) {
                super.getLocalPrefixMapping().setNsPrefix(prefix, s);
                return s;
            }
            return null;
        }

        public String getNsURIPrefix(String uri) {
            String s = super.getLocalPrefixMapping().getNsURIPrefix(uri);
            if (s != null) {
                return s;
            }
            PrefixMapping pmapGlobal = super.getGlobalPrefixMapping();
            if (pmapGlobal == null) {
                return null;
            }
            if (pmapGlobal != null) {
                s = pmapGlobal.getNsURIPrefix(uri);
            }
            super.getLocalPrefixMapping().setNsPrefix(s, uri);
            return null;
        }

        public PrefixMapping removeNsPrefix(String prefix) {
            super.getLocalPrefixMapping().removeNsPrefix(prefix);
            return this;
        }

        public String expandPrefix(String prefixed) {
            String s = super.getLocalPrefixMapping().expandPrefix(prefixed);
            PrefixMapping pmapGlobal = super.getGlobalPrefixMapping();
            if (pmapGlobal == null) {
                return s;
            }
            if (s == null || s.equals(prefixed)) {
                if (pmapGlobal != null) {
                    s = pmapGlobal.expandPrefix(prefixed);
                }
                if (s != null) {
                    int colon = prefixed.indexOf(58);
                    String prefix = prefixed.substring(0, colon);
                    String uri = pmapGlobal.getNsPrefixURI(prefix);
                    super.getLocalPrefixMapping().setNsPrefix(prefix, uri);
                }
            }
            return s;
        }

        public String shortForm(String uri) {
            PrefixMapping pmapLocal = super.getLocalPrefixMapping();
            PrefixMapping pmapGlobal = super.getGlobalPrefixMapping();
            String s = pmapLocal.shortForm(uri);
            if (pmapGlobal == null) {
                return s;
            }
            if ((s == null || s.equals(uri)) && (s = pmapGlobal.shortForm(uri)) != null && !s.equals(uri)) {
                boolean b = false;
                try {
                    b = (Boolean)checkValidPrefixMethod.invoke(null, s);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (b) {
                    String prefix = s.substring(0, s.indexOf(":"));
                    pmapLocal.setNsPrefix(prefix, pmapGlobal.getNsPrefixURI(prefix));
                }
            }
            return s;
        }

        public String qnameFor(String uri) {
            PrefixMapping pmapLocal = super.getLocalPrefixMapping();
            PrefixMapping pmapGlobal = super.getGlobalPrefixMapping();
            String s = pmapLocal.qnameFor(uri);
            if (s != null) {
                return s;
            }
            if (pmapGlobal != null && (s = pmapGlobal.qnameFor(uri)) != null) {
                boolean b = false;
                try {
                    b = (Boolean)checkValidPrefixMethod.invoke(null, s);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (b) {
                    String prefix = s.substring(0, s.indexOf(":"));
                    pmapLocal.setNsPrefix(prefix, pmapGlobal.getNsPrefixURI(prefix));
                }
            }
            return s;
        }

        public Map<String, String> getNsPrefixMap() {
            return this.getNsPrefixMap(false);
        }

        public Map<String, String> getNsPrefixMap(boolean includeGlobalMap) {
            return super.getNsPrefixMap(false);
        }

        public String toString() {
            return "LocalMapping: " + super.getLocalPrefixMapping().toString();
        }

        static {
            try {
                checkValidPrefixMethod = FmtUtils.class.getDeclaredMethod("checkValidPrefixName", String.class);
                checkValidPrefixMethod.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }
}

