/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.sparql;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.h2.CacheUtilsH2;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.qa.commons.qald.QALD4_EvaluationUtils;
import org.aksw.qa.commons.utils.Results;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQL {
    private Logger log = LoggerFactory.getLogger(SPARQL.class);
    public QueryExecutionFactory qef;
    private long timeToLive = 31104000000L;

    public SPARQL() {
        try {
            CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend((String)"./sparql", (boolean)true, (long)this.timeToLive);
            this.qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)"http://dbpedia.org/sparql", (String[])new String[0]).config().withCache(cacheFrontend).end()).create();
        }
        catch (RuntimeException e) {
            this.log.error("Could not create SPARQL interface! ", (Throwable)e);
        }
    }

    public SPARQL(String endpoint) {
        try {
            CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend((String)"./sparql", (boolean)true, (long)this.timeToLive);
            this.qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)endpoint, (String[])new String[0]).config().withCache(cacheFrontend).end()).create();
        }
        catch (RuntimeException e) {
            this.log.error("Could not create SPARQL interface! ", (Throwable)e);
        }
    }

    public Set<RDFNode> sparql(String query) {
        HashSet set = Sets.newHashSet();
        QueryExecution qe = this.qef.createQueryExecution(query);
        if (qe != null && query != null) {
            if (QALD4_EvaluationUtils.isAskType(query)) {
                set.add(new ResourceImpl(String.valueOf(qe.execAsk())));
            } else {
                ResultSet results = qe.execSelect();
                String firstVarName = (String)results.getResultVars().get(0);
                while (results.hasNext()) {
                    RDFNode node = results.next().get(firstVarName);
                    if (node == null) continue;
                    set.add(node);
                }
            }
            qe.close();
        }
        return set;
    }

    public static Set<String> extractAnswerStrings(Set<RDFNode> answers) {
        HashSet set = Sets.newHashSet();
        for (RDFNode answ : answers) {
            if (answ.isResource()) {
                set.add(answ.asResource().getURI());
                continue;
            }
            if (answ.isLiteral()) {
                Literal l = (Literal)answ;
                try {
                    set.add(l.getString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    set.add(l.getLexicalForm());
                }
                continue;
            }
            set.add(answ.toString());
        }
        return set;
    }

    public static Results executeSelect(String query, String endpoint) {
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(endpoint);
        QueryExecution qe = qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        Results res = new Results();
        res.header.addAll(rs.getResultVars());
        while (rs.hasNext()) {
            QuerySolution sol = rs.nextSolution();
            res.table.add(new ArrayList());
            for (String head : res.header) {
                String temp;
                String answer = "";
                answer = sol.get(head).isResource() ? sol.getResource(head).toString() : ((temp = sol.get(head).toString()).contains("@") ? "\"" + temp.substring(0, temp.indexOf("@")) + "\"" + temp.substring(temp.indexOf("@")) : (temp.contains("^^") ? "\"" + temp.substring(0, temp.indexOf("^")) + "\"^^<" + temp.substring(temp.indexOf("^") + 2) + ">" : temp));
                res.table.get(res.table.size() - 1).add(answer);
            }
        }
        SPARQL.closeExecFactory((QueryExecutionFactory)qef);
        return res;
    }

    public static Boolean executeAsk(String query, String endpoint) {
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(endpoint);
        QueryExecution qe = qef.createQueryExecution(query);
        SPARQL.closeExecFactory((QueryExecutionFactory)qef);
        return qe.execAsk();
    }

    public long getCacheTimeToLive() {
        return this.timeToLive;
    }

    public void setCacheTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public static boolean isValidSparqlQuery(String sparql) {
        try {
            QueryFactory.create((String)sparql);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEndpointAlive(String endpoint) {
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(endpoint);
        try {
            QueryExecution qe = qef.createQueryExecution("PREFIX foaf:    <http://xmlns.com/foaf/0.1/> ASK  { ?x foaf:name  \"Alice\" }");
            qe.execAsk();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            SPARQL.closeExecFactory((QueryExecutionFactory)qef);
        }
        return false;
    }

    private static void closeExecFactory(QueryExecutionFactory qef) {
        if (qef != null) {
            try {
                qef.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

