/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.load.json.EJDataset;
import org.aksw.qa.commons.load.json.EJQuestionFactory;
import org.aksw.qa.commons.load.json.ExtendedQALDJSONLoader;
import org.aksw.qa.commons.load.json.QaldJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QALDWriter {
    private static Logger LOGGER = LoggerFactory.getLogger(QALDWriter.class);

    public void writeQALDJsonFile(List<IQuestion> questions, String fileName) {
        File qaldjsonFile = new File(fileName);
        QaldJson qaldJson = EJQuestionFactory.getQaldJson(questions);
        EJDataset header = new EJDataset();
        header.setId(fileName);
        qaldJson.setDataset(header);
        try {
            ExtendedQALDJSONLoader.writeJson(qaldJson, qaldjsonFile, true);
        }
        catch (IOException e) {
            LOGGER.error("Could not write the file: " + fileName + " - ", (Throwable)e);
        }
    }
}

