/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.apache.jena.ext.com.google.common.base.Strings;

public class IQuestionCsvParser {
    public static String ARRAY_SPLIT = ",";
    public static String NULL_DEFAULT = "";

    private static IQuestion csvRowToQuestion(String[] csvRow, Column ... columns) throws IOException {
        List<String> splittedcsv = Arrays.asList(csvRow);
        List<Column> cols = Arrays.asList(columns);
        int maxFor = cols.size() < splittedcsv.size() ? cols.size() : splittedcsv.size();
        Question question = new Question();
        block15: for (int i = 0; i < maxFor; ++i) {
            Column colIt = cols.get(i);
            String csvIt = splittedcsv.get(i).trim();
            Column.ColEnum en = colIt.getEnum();
            String lang = colIt.getState();
            try {
                switch (en) {
                    case AGGREGATION_FLAG: {
                        question.setAggregation(IQuestionCsvParser.parseBoolean(csvIt));
                        break;
                    }
                    case ANSWER_TYPE: {
                        question.setAnswerType(csvIt.toLowerCase());
                        break;
                    }
                    case GOLDEN_ANSWERS: {
                        question.getGoldenAnswers().addAll(IQuestionCsvParser.parseStringArray(csvIt));
                        break;
                    }
                    case HYBRID_FLAG: {
                        question.setHybrid(IQuestionCsvParser.parseBoolean(csvIt));
                        break;
                    }
                    case KEYWORDS: {
                        List<String> keywords = IQuestionCsvParser.parseStringArray(csvIt);
                        if (!question.getLanguageToKeywords().keySet().contains(lang)) {
                            question.getLanguageToKeywords().put(lang, keywords);
                            break;
                        }
                        question.getLanguageToKeywords().get(lang).addAll(keywords);
                        break;
                    }
                    case ONLYDBO_FLAG: {
                        question.setOnlydbo(IQuestionCsvParser.parseBoolean(csvIt));
                        break;
                    }
                    case OUT_OF_SCOPE_FLAG: {
                        question.setOutOfScope(IQuestionCsvParser.parseBoolean(csvIt));
                        break;
                    }
                    case PSEUDO_SPARQL_QUERY: {
                        question.setPseudoSparqlQuery(csvIt);
                        break;
                    }
                    case QUESTION: {
                        question.getLanguageToQuestion().put(lang, csvIt);
                        break;
                    }
                    case SPARQL_QUERY: {
                        question.setSparqlQuery(csvIt);
                        break;
                    }
                    case __IGNORE: {
                        continue block15;
                    }
                    default: {
                        throw new ParseException("Unidentified column wrapper", 0);
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw new IOException(String.format("@Column %d : |%s| should be parsed as: %s", i, csvIt, colIt.getEnum().name()), e);
            }
        }
        return question;
    }

    public static List<IQuestion> csvToQuestionList(CSVReader reader, Column ... columns) throws IOException {
        Vector<IQuestion> questions = new Vector<IQuestion>();
        String[] row = reader.readNext();
        int lineCounter = 1;
        while (row != null) {
            try {
                questions.add(IQuestionCsvParser.csvRowToQuestion(row, columns));
            }
            catch (IOException e) {
                throw new IOException(String.format("Couldn't parse csv: @Line %s " + e.getMessage(), lineCounter), e.getCause());
            }
            row = reader.readNext();
            ++lineCounter;
        }
        return questions;
    }

    public static void questionListToCsv(CSVWriter writer, boolean columnDescriptorgRow, List<IQuestion> questions, Column ... columns) throws IOException {
        if (columnDescriptorgRow) {
            int index = 0;
            String[] names = new String[columns.length];
            for (Column it : columns) {
                names[index] = it.getEnum().name();
                if (it.getState() != null) {
                    int n = index;
                    names[n] = names[n] + String.format(" [%s]", it.getState());
                }
                ++index;
            }
            writer.writeNext(names);
        }
        for (IQuestion it : questions) {
            ArrayList<String> colString = new ArrayList<String>(columns.length);
            block16: for (Column colIt : Arrays.asList(columns)) {
                Column.ColEnum en = colIt.getEnum();
                switch (en) {
                    case AGGREGATION_FLAG: {
                        colString.add(Objects.toString(it.getAggregation(), NULL_DEFAULT));
                        continue block16;
                    }
                    case ANSWER_TYPE: {
                        colString.add(Objects.toString(it.getAnswerType(), NULL_DEFAULT));
                        continue block16;
                    }
                    case GOLDEN_ANSWERS: {
                        colString.add(Objects.toString(it.getGoldenAnswers(), NULL_DEFAULT));
                        continue block16;
                    }
                    case HYBRID_FLAG: {
                        colString.add(Objects.toString(it.getHybrid(), NULL_DEFAULT));
                        continue block16;
                    }
                    case ID: {
                        colString.add(Objects.toString(it.getId(), NULL_DEFAULT));
                        continue block16;
                    }
                    case KEYWORDS: {
                        colString.add(Objects.toString(it.getLanguageToKeywords().get(colIt.getState()), NULL_DEFAULT));
                        continue block16;
                    }
                    case ONLYDBO_FLAG: {
                        colString.add(Objects.toString(it.getOnlydbo(), NULL_DEFAULT));
                        continue block16;
                    }
                    case OUT_OF_SCOPE_FLAG: {
                        colString.add(Objects.toString(it.getOutOfScope(), NULL_DEFAULT));
                        continue block16;
                    }
                    case PSEUDO_SPARQL_QUERY: {
                        colString.add(Objects.toString(it.getPseudoSparqlQuery(), NULL_DEFAULT));
                        continue block16;
                    }
                    case QUESTION: {
                        colString.add(Objects.toString(it.getLanguageToQuestion().get(colIt.getState()), NULL_DEFAULT));
                        continue block16;
                    }
                    case SPARQL_QUERY: {
                        colString.add(Objects.toString(it.getSparqlQuery(), NULL_DEFAULT));
                        continue block16;
                    }
                    case __IGNORE: {
                        colString.add(NULL_DEFAULT);
                        continue block16;
                    }
                }
                throw new IOException("No case statement for enum.");
            }
            String[] ls = new String[colString.size()];
            colString.toArray(ls);
            writer.writeNext(ls);
        }
    }

    private static Boolean parseBoolean(String boolStr) throws IOException {
        if (Strings.isNullOrEmpty((String)boolStr)) {
            throw new IOException(String.format("Coluldn't parse Boolean :|%s| empy or null not allowed.", boolStr));
        }
        String cleaned = boolStr.trim().toLowerCase();
        if (cleaned.matches(Boolean.TRUE.toString()) || cleaned.matches(Boolean.FALSE.toString())) {
            return Boolean.parseBoolean(cleaned);
        }
        throw new IOException(String.format("Coluldn't parse Boolean :|%s| is not valid.", boolStr));
    }

    private static List<String> parseStringArray(String arrayStr) {
        String cleaned = arrayStr.trim();
        if (cleaned.startsWith("[") || cleaned.startsWith("{")) {
            cleaned = cleaned.substring(1);
        }
        if (cleaned.endsWith("]") || cleaned.endsWith("}")) {
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        return Arrays.asList(cleaned.split(ARRAY_SPLIT));
    }

    public static CSVReader readerForGoogleDocsCsvExports(Reader reader, int skipLines) {
        return new CSVReader(reader, ',', '\"', skipLines);
    }

    static class Column {
        private ColEnum en;
        private String state;

        private Column(ColEnum en, String state) {
            this.en = en;
            this.state = state;
        }

        protected ColEnum getEnum() {
            return this.en;
        }

        protected String getState() {
            return this.state;
        }

        protected Column(ColEnum en) {
            this(en, null);
        }

        protected static Column ignore() {
            return new Column(ColEnum.__IGNORE);
        }

        protected static Column iD() {
            return new Column(ColEnum.ID);
        }

        protected static Column aggregationFlag() {
            return new Column(ColEnum.AGGREGATION_FLAG);
        }

        protected static Column onlyDboFlag() {
            return new Column(ColEnum.ONLYDBO_FLAG);
        }

        protected static Column outOfScopeFlag() {
            return new Column(ColEnum.OUT_OF_SCOPE_FLAG);
        }

        protected static Column hybridFlag() {
            return new Column(ColEnum.HYBRID_FLAG);
        }

        protected static Column sparqlQuery() {
            return new Column(ColEnum.SPARQL_QUERY);
        }

        protected static Column pseudoSparqlQuery() {
            return new Column(ColEnum.PSEUDO_SPARQL_QUERY);
        }

        protected static Column answerType() {
            return new Column(ColEnum.ANSWER_TYPE);
        }

        protected static Column goldenAnswers() {
            return new Column(ColEnum.GOLDEN_ANSWERS);
        }

        protected static Column question(String lang) {
            return new Column(ColEnum.QUESTION, lang);
        }

        protected static Column keywords(String lang) {
            return new Column(ColEnum.KEYWORDS, lang);
        }

        protected static enum ColEnum {
            __IGNORE,
            ID,
            AGGREGATION_FLAG,
            ONLYDBO_FLAG,
            OUT_OF_SCOPE_FLAG,
            HYBRID_FLAG,
            SPARQL_QUERY,
            PSEUDO_SPARQL_QUERY,
            ANSWER_TYPE,
            GOLDEN_ANSWERS,
            QUESTION,
            KEYWORDS;

        }
    }
}

