/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.measure;

import java.util.HashSet;
import java.util.Set;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnswerBasedEvaluation {
    private static Logger log = LoggerFactory.getLogger(AnswerBasedEvaluation.class);

    public static double precision(Set<String> systemAnswer, IQuestion question) {
        if (systemAnswer == null) {
            return 0.0;
        }
        double precision = 0.0;
        Set<String> goldenStrings = AnswerBasedEvaluation.answersToString(question.getGoldenAnswers());
        if (question.getPseudoSparqlQuery() != null) {
            if (AnswerBasedEvaluation.isSelectType(question.getPseudoSparqlQuery())) {
                Set<String> intersection = CollectionUtils.intersection(goldenStrings, systemAnswer);
                if (systemAnswer.size() != 0) {
                    precision = (double)intersection.size() / (double)systemAnswer.size();
                }
            } else if (AnswerBasedEvaluation.isAskType(question.getPseudoSparqlQuery())) {
                String goldstandardAns;
                String ans;
                if (systemAnswer.size() == 1 && (ans = systemAnswer.iterator().next()).equals((goldstandardAns = goldenStrings.iterator().next()).toString())) {
                    precision = 1.0;
                }
            } else {
                log.error("Unsupported Query Type" + question.getPseudoSparqlQuery());
            }
        } else if (question.getSparqlQuery() != null) {
            if (AnswerBasedEvaluation.isSelectType(question.getSparqlQuery())) {
                Set<String> intersection = CollectionUtils.intersection(goldenStrings, systemAnswer);
                if (systemAnswer.size() != 0) {
                    precision = (double)intersection.size() / (double)systemAnswer.size();
                }
            } else if (AnswerBasedEvaluation.isAskType(question.getSparqlQuery())) {
                String goldstandardAns;
                String ans;
                if (systemAnswer.size() == 1 && (ans = systemAnswer.iterator().next()).equals(goldstandardAns = goldenStrings.iterator().next())) {
                    precision = 1.0;
                }
            } else {
                log.error("Unsupported Query Type" + question.getSparqlQuery());
            }
        }
        return precision;
    }

    public static double recall(Set<String> systemAnswer, IQuestion question) {
        if (systemAnswer == null) {
            return 0.0;
        }
        double recall = 0.0;
        Set<String> goldenStrings = AnswerBasedEvaluation.answersToString(question.getGoldenAnswers());
        Boolean aggregation = question.getAggregation() == null ? false : question.getAggregation();
        if (question.getPseudoSparqlQuery() != null) {
            if (AnswerBasedEvaluation.isSelectType(question.getPseudoSparqlQuery())) {
                if (aggregation.booleanValue()) {
                    recall = 1.0;
                }
                Set<String> intersection = CollectionUtils.intersection(systemAnswer, goldenStrings);
                if (goldenStrings.size() != 0) {
                    recall = (double)intersection.size() / (double)goldenStrings.size();
                }
            } else if (AnswerBasedEvaluation.isAskType(question.getPseudoSparqlQuery())) {
                recall = 1.0;
            } else {
                log.error("Unsupported Query Type" + question.getPseudoSparqlQuery());
            }
        } else if (question.getSparqlQuery() != null) {
            if (AnswerBasedEvaluation.isSelectType(question.getSparqlQuery())) {
                if (aggregation.booleanValue()) {
                    recall = 1.0;
                }
                Set<String> intersection = CollectionUtils.intersection(systemAnswer, goldenStrings);
                if (goldenStrings.size() != 0) {
                    recall = (double)intersection.size() / (double)goldenStrings.size();
                }
            } else if (AnswerBasedEvaluation.isAskType(question.getSparqlQuery())) {
                recall = 1.0;
            } else {
                log.error("Unsupported Query Type" + question.getSparqlQuery());
            }
        }
        return recall;
    }

    public static double fMeasure(Set<String> systemAnswers, IQuestion question) {
        double precision = AnswerBasedEvaluation.precision(systemAnswers, question);
        double recall = AnswerBasedEvaluation.recall(systemAnswers, question);
        double fMeasure = 0.0;
        if (precision + recall > 0.0) {
            fMeasure = 2.0 * precision * recall / (precision + recall);
        }
        return fMeasure;
    }

    public static boolean isAskType(String sparqlQuery) {
        String query = sparqlQuery.toUpperCase();
        return query.contains("\nASK\n") || query.contains("ASK ");
    }

    public static boolean isSelectType(String sparqlQuery) {
        String query = sparqlQuery.toUpperCase();
        return query.contains("\nSELECT\n") || query.contains("SELECT ");
    }

    private static Set<String> answersToString(Set<String> answers) {
        HashSet<String> tmp = CollectionUtils.newHashSet();
        for (String s : answers) {
            tmp.add(s);
        }
        return tmp;
    }
}

