/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.tsv;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.load.json.EJLanguage;

public class LoadTsv {
    public static final String SPLIT_KEYWORDS_ON = " ";

    public static List<IQuestion> readTSV(InputStream queriesStream, InputStream qrels, String data) throws IOException {
        String[] lineparts;
        String line;
        ArrayList<IQuestion> DbeQuestions = new ArrayList<IQuestion>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(qrels, "UTF-8"));
        HashMap<String, Set> results = new HashMap<String, Set>();
        HashMap<String, String> queries = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith(data)) continue;
            lineparts = line.split("\t");
            String result = lineparts[2].replaceAll("<dbpedia:", "http://dbpedia.org/resource/");
            result = result.substring(0, result.length() - 1);
            results.computeIfAbsent(lineparts[0], k -> new HashSet()).add(result);
        }
        reader.close();
        reader = new BufferedReader(new InputStreamReader(queriesStream, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            lineparts = line.split("\t");
            if (!line.startsWith(data)) continue;
            queries.put(lineparts[0], lineparts[1]);
        }
        reader.close();
        for (Map.Entry entry : queries.entrySet()) {
            Question question = new Question();
            HashMap<String, String> langToQuestion = new HashMap<String, String>();
            HashMap<String, List<String>> langToKeywords = new HashMap<String, List<String>>();
            question.setId((String)entry.getKey());
            question.setAnswerType("resource");
            question.setGoldenAnswers((Set)results.get(entry.getKey()));
            EJLanguage lang = new EJLanguage();
            question.setId((String)entry.getKey());
            langToQuestion.put(lang.getLanguage(), (String)entry.getValue());
            langToKeywords.put(lang.getLanguage(), Arrays.asList(((String)entry.getValue()).split(SPLIT_KEYWORDS_ON)));
            question.setLanguageToKeywords(langToKeywords);
            question.setLanguageToQuestion(langToQuestion);
            DbeQuestions.add(question);
        }
        return DbeQuestions;
    }

    public static List<IQuestion> readSimpleQuestionsTsv(InputStream in) throws IOException {
        String line;
        ArrayList<IQuestion> questions = new ArrayList<IQuestion>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        int id = 1;
        while ((line = reader.readLine()) != null) {
            String[] cols = line.split("\t");
            Question question = new Question();
            question.setId(String.valueOf(id++));
            question.setAnswerType("resource");
            question.setGoldenAnswers(Sets.newHashSet((Object[])new String[]{"http://www.wikidata.org/entity/" + cols[2]}));
            HashMap<String, String> langToQuestion = new HashMap<String, String>();
            langToQuestion.put("en", cols[3]);
            question.setLanguageToQuestion(langToQuestion);
            questions.add(question);
        }
        return questions;
    }
}

