/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.stanford;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.http.QueryExecutionHttpWrapper;
import org.aksw.qa.commons.datastructure.Entity;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.aksw.qa.commons.load.stanford.DBpediaIndex;
import org.aksw.qa.commons.nlp.nerd.AGDISTIS;
import org.aksw.qa.commons.nlp.nerd.Spotlight;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.util.iterator.Filter;
import org.apache.jena.vocabulary.RDFS;
import org.dllearner.algorithms.qtl.QueryTreeUtils;
import org.dllearner.algorithms.qtl.datastructures.impl.RDFResourceTree;
import org.dllearner.algorithms.qtl.impl.QueryTreeFactoryBase;
import org.dllearner.algorithms.qtl.operations.lgg.LGGGeneratorSimple;
import org.dllearner.algorithms.qtl.util.StopURIsDBpedia;
import org.dllearner.algorithms.qtl.util.StopURIsOWL;
import org.dllearner.algorithms.qtl.util.StopURIsRDFS;
import org.dllearner.algorithms.qtl.util.StopURIsSKOS;
import org.dllearner.algorithms.qtl.util.filters.NamespaceDropStatementFilter;
import org.dllearner.algorithms.qtl.util.filters.ObjectDropStatementFilter;
import org.dllearner.algorithms.qtl.util.filters.PredicateDropStatementFilter;
import org.dllearner.kb.sparql.ConciseBoundedDescriptionGeneratorImpl;
import org.dllearner.kb.sparql.SymmetricConciseBoundedDescriptionGeneratorImpl;
import org.json.simple.parser.ParseException;

public class StanfordRDFizer {
    private AGDISTIS disambiguator = new AGDISTIS();
    private Spotlight recognizer = new Spotlight();
    private DBpediaIndex index = new DBpediaIndex();

    public Map<String, List<Entity>> recognize(String question) {
        return this.recognizer.getEntities(question);
    }

    public String disambiguate(String label) {
        String preAnnotatedText = "<entity>" + label + "</entity>";
        try {
            HashMap<String, String> results = this.disambiguator.runDisambiguation(preAnnotatedText);
            Iterator<String> iterator = results.keySet().iterator();
            if (iterator.hasNext()) {
                String namedEntity = iterator.next();
                return results.get(namedEntity);
            }
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        Dataset[] datasets;
        QueryExecutionFactory qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)"http://dbpedia.org/sparql", (Collection)Lists.newArrayList((Object[])new String[]{"http://dbpedia.org"})).config().withPostProcessor(qe -> ((QueryEngineHTTP)((QueryExecutionHttpWrapper)qe).getDecoratee()).setModelContentType("application/rdf+xml")).end()).create();
        ConciseBoundedDescriptionGeneratorImpl cbdGen = new ConciseBoundedDescriptionGeneratorImpl(qef);
        cbdGen = new SymmetricConciseBoundedDescriptionGeneratorImpl(qef);
        QueryTreeFactoryBase qtf = new QueryTreeFactoryBase();
        ArrayList treeFilters = Lists.newArrayList((Object[])new Predicate[]{new PredicateDropStatementFilter(StopURIsDBpedia.get()), new ObjectDropStatementFilter(StopURIsDBpedia.get()), new PredicateDropStatementFilter((Set)Sets.union((Set)StopURIsRDFS.get(), (Set)Sets.newHashSet((Object[])new String[]{RDFS.seeAlso.getURI()}))), new PredicateDropStatementFilter(StopURIsOWL.get()), new ObjectDropStatementFilter(StopURIsOWL.get()), new PredicateDropStatementFilter(StopURIsSKOS.get()), new ObjectDropStatementFilter(StopURIsSKOS.get()), new NamespaceDropStatementFilter((Set)Sets.newHashSet((Object[])new String[]{"http://dbpedia.org/property/", "http://purl.org/dc/terms/", "http://dbpedia.org/class/yago/", FOAF.getURI()})), new PredicateDropStatementFilter((Set)Sets.newHashSet((Object[])new String[]{"http://www.w3.org/2002/07/owl#equivalentClass", "http://www.w3.org/2002/07/owl#disjointWith"}))});
        qtf.addDropFilters((Predicate[])treeFilters.toArray(new Filter[treeFilters.size()]));
        LGGGeneratorSimple lggGen = new LGGGeneratorSimple();
        StanfordRDFizer stan = new StanfordRDFizer();
        for (Dataset dataset : datasets = new Dataset[]{Dataset.Stanford_dev}) {
            List<IQuestion> questions = LoaderController.load(Dataset.Stanford_dev);
            BufferedWriter bw = new BufferedWriter(new FileWriter(datasets.toString().toLowerCase() + ".tsv"));
            int numberOfQuestions = 0;
            for (IQuestion q : questions) {
                String question = q.getLanguageToQuestion().get("en");
                HashSet<String> disambiguatedAnswers = new HashSet<String>();
                for (String answer : q.getGoldenAnswers()) {
                    String disambiguate = stan.disambiguate(answer);
                    System.out.println("Number of Questions: " + numberOfQuestions + ". Question: " + question);
                    ++numberOfQuestions;
                    bw.write(question + "\t");
                    if (disambiguate != null) {
                        System.out.println("\tDisambiguated Answer: " + answer + " -> " + disambiguate);
                        bw.write(answer + "\t");
                        bw.write(disambiguate + "\t");
                        disambiguatedAnswers.add(disambiguate);
                    } else {
                        bw.write(answer + "\t");
                        bw.write("null\t");
                    }
                    System.out.print("\tRecognized Entities in Question: ");
                    Map<String, List<Entity>> recognize = stan.recognize(question);
                    if (!recognize.isEmpty()) {
                        recognize.get("en").forEach(x -> {
                            try {
                                bw.write(x.getUris().get(0) + "\t");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            System.out.print(x.getUris().get(0) + "\t");
                        });
                        System.out.println("\n");
                    }
                    System.out.print("\tRecognized Classes and Properties in Question: ");
                    Arrays.stream(question.replaceAll("[^\\w]", " ").replaceAll("[\\d]", "").replaceAll("  ", " ").split(" ")).forEach(y -> {
                        ArrayList<String> classOrProperty = stan.index.search((String)y);
                        if (!classOrProperty.isEmpty()) {
                            classOrProperty.forEach(x -> {
                                try {
                                    bw.write(x + "\t");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                System.out.print(x + "\t");
                            });
                            System.out.println();
                        }
                    });
                    System.out.println("\n");
                    int minNrOfExamples = 2;
                    if (disambiguatedAnswers.size() < minNrOfExamples) continue;
                    ArrayList<RDFResourceTree> trees = new ArrayList<RDFResourceTree>(disambiguatedAnswers.size());
                    for (String uri : disambiguatedAnswers) {
                        Model cbd = cbdGen.getConciseBoundedDescription(uri);
                        System.out.println("|cbd(" + uri + ")|=" + cbd.size() + " triples");
                        RDFResourceTree tree = qtf.getQueryTree(uri, cbd);
                        trees.add(tree);
                    }
                    RDFResourceTree lgg = lggGen.getLGG(trees);
                    Query query = QueryTreeUtils.toSPARQLQuery((RDFResourceTree)lgg);
                    System.out.println(query);
                }
            }
        }
    }
}

