/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.aksw.qa.commons.load.json.ExtendedJson;
import org.aksw.qa.commons.load.json.QaldJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtendedQALDJSONLoader {
    private static Logger LOGGER = LoggerFactory.getLogger(ExtendedQALDJSONLoader.class);

    private ExtendedQALDJSONLoader() {
    }

    public static void writeJson(Object o, File f, boolean overwrite) throws IOException {
        if (f.exists() && !overwrite) {
            throw new IllegalArgumentException("File already exists. Set overwrite flag if you want to overwrite current file");
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS});
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(f, o);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        LOGGER.info("File Written to " + f.getAbsolutePath());
    }

    public static byte[] writeJson(Object json) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS});
        return mapper.writer().writeValueAsBytes(json);
    }

    public static Object readJson(byte[] inputJson, Class<?> type) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS});
        return mapper.readValue(inputJson, type);
    }

    public static Object readJson(InputStream in, Class<?> type) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS});
        return mapper.readValue(in, type);
    }

    public static Object readJson(InputStream in) throws JsonParseException, JsonMappingException, IOException {
        Object ret = null;
        try {
            ret = ExtendedQALDJSONLoader.readJson(in, ExtendedJson.class);
        }
        catch (JsonParseException | JsonMappingException e1) {
            LOGGER.debug("Parsing as ExtendedJson doesnt work, trying QaldJson", e1);
            ret = ExtendedQALDJSONLoader.readJson(in, QaldJson.class);
        }
        return ret;
    }

    public static Object readJson(File f) throws FileNotFoundException, IOException {
        Object ret = null;
        try {
            ret = ExtendedQALDJSONLoader.readJson(f, ExtendedJson.class);
        }
        catch (JsonParseException | JsonMappingException e1) {
            LOGGER.debug("Parsing as ExtendedJson doesnt work, trying QaldJson", e1);
            ret = ExtendedQALDJSONLoader.readJson(f, QaldJson.class);
        }
        return ret;
    }

    public static Object readJson(File f, Class<?> type) throws JsonParseException, JsonMappingException, FileNotFoundException, IOException {
        return ExtendedQALDJSONLoader.readJson(new FileInputStream(f), type);
    }
}

