/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.knowledgecard;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;
import org.aksw.qa.commons.knowledgecard.ExplorerProperties;
import org.aksw.qa.commons.knowledgecard.Field;
import org.apache.jena.ext.com.google.common.collect.Sets;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;

public class KnowledgeCardCreator {
    private static final int MAX_FIELD_SIZE = 5;
    private static final int API_TIMEOUT = 5000;
    private static final String ENDPOINT = "http://dbpedia.org/sparql";
    private static final String PREFIXES = new String("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX dbo: <http://dbpedia.org/ontology/>\nPREFIX dbp: <http://dbpedia.org/property/>\nPREFIX dbr: <http://dbpedia.org/resource/>\nPREFIX dct: <http://purl.org/dc/terms/>\n");

    private QueryExecution executeQuery(String queryString) {
        Query query = QueryFactory.create((String)queryString);
        QueryEngineHTTP queryEngine = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)ENDPOINT, (Query)query);
        queryEngine.addParam("timeout", String.valueOf(5000));
        return queryEngine;
    }

    public String process(String uri) throws JsonGenerationException, IOException {
        String query = PREFIXES + "SELECT (GROUP_CONCAT(distinct ?type;separator=' ') as ?types) (GROUP_CONCAT(distinct ?property;separator=' ') as ?properties) WHERE {\n<" + uri + "> rdf:type ?type . FILTER(STRSTARTS(STR(?type), 'http://dbpedia.org/ontology')) . \n<" + uri + "> ?property ?value . FILTER(STRSTARTS(STR(?property), 'http://dbpedia.org/ontology')) . \n}";
        QueryExecution queryExecution = this.executeQuery(query);
        ResultSet results = queryExecution.execSelect();
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        while (results.hasNext()) {
            QuerySolution solution = (QuerySolution)results.next();
            if (solution.get("types") == null || solution.get("properties") == null) continue;
            List<String> types = Arrays.asList(solution.get("types").asLiteral().getString().split(" "));
            Object[] split = solution.get("properties").asLiteral().getString().split(" ");
            HashSet properties = Sets.newHashSet((Object[])split);
            List<Field> relevantProperties = this.getRelevantProperties(uri, types, properties);
            fields.addAll(relevantProperties);
        }
        queryExecution.close();
        return JsonUtils.toPrettyString(fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Field> getRelevantProperties(String uri, List<String> Answer, HashSet<String> properties) {
        ArrayList<Field> arrayList;
        ArrayList<Field> fields = new ArrayList<Field>();
        TreeMap<Float, String> propertyMap = new TreeMap<Float, String>();
        List<ExplorerProperties> explorerProperties = this.readCSVWithExplorerProperties(properties);
        for (ExplorerProperties property : explorerProperties) {
            if (!Answer.contains(property.getClassName())) continue;
            propertyMap.put(Float.valueOf(Float.parseFloat(property.getScore())), property.getProperty());
        }
        if (propertyMap.size() <= 0) return fields;
        Iterator iterator = propertyMap.descendingKeySet().iterator();
        String property_uris = "";
        for (int count = 0; count < 5 && iterator.hasNext(); ++count) {
            property_uris = property_uris + "<" + (String)propertyMap.get(iterator.next()) + "> ";
        }
        String query = PREFIXES + "SELECT ?property_label (group_concat(distinct ?value;separator='__') as ?values) (group_concat(distinct ?value_label;separator='__') as ?value_labels) where {\nVALUES ?property {" + property_uris + "}\n<" + uri + "> ?property ?value . \n?property rdfs:label ?property_label . FILTER(lang(?property_label)='en'). \nOPTIONAL {?value rdfs:label ?value_label . FILTER(lang(?value_label) = 'en') }\n} GROUP BY ?property_label";
        QueryExecution queryExecution = this.executeQuery(query);
        try {
            ResultSet results = queryExecution.execSelect();
            while (results.hasNext()) {
                QuerySolution result = (QuerySolution)results.next();
                Field field = new Field();
                field.setName(result.get("property_label").asLiteral().getString());
                if (result.get("value_labels").asLiteral().getString().equals("")) {
                    field.setValue(result.get("values").asLiteral().getString().split("__")[0]);
                } else {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    String[] keyArray = result.get("values").asLiteral().getString().split("__");
                    String[] valueArray = result.get("value_labels").asLiteral().getString().split("__");
                    for (int index = 0; index < keyArray.length; ++index) {
                        map.put(keyArray[index], valueArray[index]);
                    }
                    field.setValues(map);
                }
                fields.add(field);
            }
            arrayList = fields;
        }
        catch (Throwable throwable) {
            try {
                queryExecution.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return fields;
            }
        }
        queryExecution.close();
        return arrayList;
    }

    private List<ExplorerProperties> readCSVWithExplorerProperties(HashSet<String> properties) throws IOException {
        InputStream openResource = this.getClass().getClassLoader().getResourceAsStream("db.csv");
        InputStreamReader in = new InputStreamReader(openResource);
        BufferedReader br = new BufferedReader(in);
        ArrayList<ExplorerProperties> tmp = new ArrayList<ExplorerProperties>();
        while (br.ready()) {
            String[] line = br.readLine().split(",");
            if (!properties.contains(line[1])) continue;
            tmp.add(new ExplorerProperties(line[0], line[1], line[2]));
        }
        br.close();
        return tmp;
    }
}

