/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.store;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.jena.ext.com.google.common.base.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StoreQALDXML {
    private final String dataset;
    private final List<Element> questions;
    private final Document doc;

    public StoreQALDXML(String dataset) throws IOException, ParserConfigurationException {
        this.dataset = dataset;
        this.questions = new ArrayList();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
    }

    public static void main(String[] args) {
    }

    public void close() throws IOException, TransformerFactoryConfigurationError, TransformerException {
        Element root = this.doc.createElement("dataset");
        root.setAttribute("id", this.dataset);
        this.doc.appendChild(root);
        for (Element question : this.questions) {
            root.appendChild(question);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(this.doc);
        StreamResult file = new StreamResult(new File("answer_" + this.dataset + ".xml"));
        transformer.transform(source, file);
        System.out.println("\nXML DOM Created Successfully..");
    }

    public void close(String path, String datasetName) throws IOException, TransformerFactoryConfigurationError, TransformerException {
        Element root = this.doc.createElement("dataset");
        root.setAttribute("id", datasetName);
        this.doc.appendChild(root);
        for (Element question : this.questions) {
            root.appendChild(question);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(this.doc);
        StreamResult file = new StreamResult(new File(path));
        transformer.transform(source, file);
        System.out.println("\nXML DOM Created Successfully..");
    }

    public void write(String questionString, String queryString, Set<String> answerSet, Integer questionID) throws ParserConfigurationException, IOException {
        if (questionString != null) {
            Element question = this.doc.createElement("question");
            if (questionID != null) {
                question.setAttribute("id", String.valueOf(questionID));
            }
            question.setAttribute("answertype", "resource");
            question.setAttribute("aggregation", "false");
            question.setAttribute("onlydbo", "true");
            question.setAttribute("hybrid", "true");
            Element string = this.doc.createElement("string");
            string.setAttribute("lang", "en");
            string.setTextContent(questionString);
            question.appendChild(string);
            Element pseudoquery = this.doc.createElement("pseudoquery");
            pseudoquery.setTextContent(queryString);
            question.appendChild(pseudoquery);
            Element answers = this.doc.createElement("answers");
            for (String uri : answerSet) {
                Element answer = this.doc.createElement("answer");
                answer.setTextContent(uri);
                answers.appendChild(answer);
            }
            question.appendChild(answers);
            this.questions.add(question);
        }
    }

    public void write(IQuestion q) throws ParserConfigurationException, IOException {
        Element question = this.doc.createElement("question");
        question.setAttribute("id", String.valueOf(q.getId()));
        question.setAttribute("answertype", q.getAnswerType());
        question.setAttribute("aggregation", "" + q.getAggregation());
        question.setAttribute("onlydbo", "" + q.getOnlydbo());
        question.setAttribute("hybrid", "" + q.getHybrid());
        for (String key : q.getLanguageToQuestion().keySet()) {
            if (Strings.isNullOrEmpty((String)((String)q.getLanguageToQuestion().get(key)))) continue;
            Element string = this.doc.createElement("string");
            string.setAttribute("lang", key);
            string.setTextContent((String)q.getLanguageToQuestion().get(key));
            question.appendChild(string);
        }
        for (String key : q.getLanguageToKeywords().keySet()) {
            if (CollectionUtils.isEmpty((Collection)((Collection)q.getLanguageToKeywords().get(key)))) continue;
            Element keyword = this.doc.createElement("keywords");
            keyword.setAttribute("lang", key);
            keyword.setTextContent(Joiner.on((String)", ").join((Iterable)q.getLanguageToKeywords().get(key)));
            question.appendChild(keyword);
        }
        if (q.getPseudoSparqlQuery() != null && !q.getPseudoSparqlQuery().isEmpty()) {
            Element pseudoquery = this.doc.createElement("pseudoquery");
            pseudoquery.setTextContent(q.getPseudoSparqlQuery());
            question.appendChild(pseudoquery);
        }
        if (q.getSparqlQuery() != null && !q.getSparqlQuery().isEmpty()) {
            Element query = this.doc.createElement("query");
            query.setTextContent(q.getSparqlQuery());
            question.appendChild(query);
        }
        Element answers = this.doc.createElement("answers");
        for (String uri : q.getGoldenAnswers()) {
            Element answer = this.doc.createElement("answer");
            answer.setTextContent(uri);
            answers.appendChild(answer);
        }
        question.appendChild(answers);
        this.questions.add(question);
    }
}

