/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.sparql;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.h2.CacheUtilsH2;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.qa.commons.qald.QALD4_EvaluationUtils;
import org.aksw.qa.commons.sparql.SPARQLQuery;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQL {
    private Logger log = LoggerFactory.getLogger(SPARQL.class);
    public QueryExecutionFactory qef;
    private long timeToLive = 31104000000L;

    public SPARQL() {
        try {
            CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend((String)"./sparql", (boolean)true, (long)this.timeToLive);
            this.qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)"http://dbpedia.org/sparql", (String[])new String[0]).config().withCache(cacheFrontend).end()).create();
        }
        catch (RuntimeException e) {
            this.log.error("Could not create SPARQL interface! ", (Throwable)e);
        }
    }

    public SPARQL(String endpoint) {
        try {
            CacheFrontend cacheFrontend = CacheUtilsH2.createCacheFrontend((String)"./sparql", (boolean)true, (long)this.timeToLive);
            this.qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)endpoint, (String[])new String[0]).config().withCache(cacheFrontend).end()).create();
        }
        catch (RuntimeException e) {
            this.log.error("Could not create SPARQL interface! ", (Throwable)e);
        }
    }

    public Set<RDFNode> sparql(String query) throws ExecutionException {
        HashSet set = Sets.newHashSet();
        QueryExecution qe = this.qef.createQueryExecution(query);
        if (qe != null && query.toString() != null) {
            if (QALD4_EvaluationUtils.isAskType((String)query)) {
                set.add(new ResourceImpl(String.valueOf(qe.execAsk())));
            } else {
                ResultSet results = qe.execSelect();
                String firstVarName = (String)results.getResultVars().get(0);
                while (results.hasNext()) {
                    RDFNode node = results.next().get(firstVarName);
                    if (node == null) continue;
                    set.add(node);
                }
            }
            qe.close();
        }
        return set;
    }

    public static Set<String> extractAnswerStrings(Set<RDFNode> answers) {
        HashSet set = Sets.newHashSet();
        for (RDFNode answ : answers) {
            if (answ.isResource()) {
                set.add(answ.asResource().getURI());
                continue;
            }
            if (answ.isLiteral()) {
                Literal l = (Literal)answ;
                try {
                    set.add(l.getString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    set.add(l.getLexicalForm());
                }
                continue;
            }
            set.add(answ.toString());
        }
        return set;
    }

    public long getCacheTimeToLive() {
        return this.timeToLive;
    }

    public void setCacheTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public static boolean isValidSparqlQuery(String sparql) {
        try {
            QueryFactory.create((String)sparql);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        SPARQL sqb = new SPARQL();
        SPARQLQuery query = new SPARQLQuery();
        query.addConstraint("?proj a <http://dbpedia.org/ontology/Person>.");
        for (String q : query.generateQueries()) {
            Set set = sqb.sparql(q);
            for (RDFNode item : set) {
                System.out.println(item);
            }
        }
    }
}

