/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.aksw.qa.commons.load.json.EJDataset;
import org.aksw.qa.commons.load.json.EJQuestionFactory;
import org.aksw.qa.commons.load.json.ExtendedQALDJSONLoader;
import org.aksw.qa.commons.load.json.QaldJson;
import org.aksw.qa.commons.qald.IQuestionCsvParser;
import org.aksw.qa.commons.sparql.AnswerSyncer;
import org.aksw.qa.commons.sparql.SPARQL;
import org.aksw.qa.commons.sparql.SPARQLPrefixResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public class Qald8Creation {
    public static void main(String[] args) throws Exception {
        Qald8Creation.qald8test();
        Qald8Creation.qald8train();
    }

    public static void qald8train() throws Exception {
        List questions = LoaderController.load((Dataset)Dataset.QALD7_Train_Multilingual);
        List questions7test = LoaderController.load((Dataset)Dataset.QALD7_Test_Multilingual);
        for (IQuestion q : questions7test) {
            q.setId(Integer.parseInt(q.getId()) + 300 + "");
        }
        questions.addAll(questions7test);
        Vector failQuestions = new Vector();
        List<String> skipId = Arrays.asList("15", "30", "43", "57", "62", "90", "94", "124", "199", "213");
        Vector<IQuestion> removeQuestions = new Vector<IQuestion>();
        for (Object it : questions) {
            if (!skipId.contains(it.getId())) continue;
            removeQuestions.add((IQuestion)it);
        }
        questions.removeAll(removeQuestions);
        failQuestions.addAll(removeQuestions);
        removeQuestions.clear();
        for (Object it : questions) {
            String newSparql = SPARQLPrefixResolver.addMissingPrefixes((String)it.getSparqlQuery());
            it.setSparqlQuery(newSparql);
        }
        for (Object it : questions) {
            if (SPARQL.isValidSparqlQuery((String)it.getSparqlQuery())) continue;
            removeQuestions.add((IQuestion)it);
        }
        questions.removeAll(removeQuestions);
        failQuestions.addAll(removeQuestions);
        removeQuestions.clear();
        for (Object it : questions) {
            try {
                AnswerSyncer.syncAnswers((IQuestion)it, (String)"http://dbpedia.org/sparql");
            }
            catch (Exception e) {
                removeQuestions.add((IQuestion)it);
            }
        }
        questions.removeAll(removeQuestions);
        failQuestions.addAll(removeQuestions);
        removeQuestions.clear();
        for (Object it : questions) {
            if (!it.getGoldenAnswers().isEmpty()) continue;
            removeQuestions.add((IQuestion)it);
        }
        questions.removeAll(removeQuestions);
        failQuestions.addAll(removeQuestions);
        removeQuestions.clear();
        int newID = 1;
        for (IQuestion q : questions) {
            q.setId("" + newID++);
        }
        File parentDir = new File("c:/output/qald8/");
        File qaldjsonFile = new File(parentDir, "qald-8-train-multilingual.json ");
        qaldjsonFile.delete();
        QaldJson qaldJson = EJQuestionFactory.getQaldJson((List)questions);
        EJDataset header = new EJDataset();
        header.setId("qald-8-train-multilingual");
        qaldJson.setDataset(header);
        ExtendedQALDJSONLoader.writeJson((Object)qaldJson, (File)qaldjsonFile, (boolean)true);
        File f = new File(parentDir, "qald8trainGOOD_QUESTIONS.csv ");
        f.delete();
        FileWriter fw = new FileWriter(f);
        CSVWriter wr = new CSVWriter((Writer)fw, ';', '\"');
        IQuestionCsvParser.questionListToCsv((CSVWriter)wr, (boolean)true, (List)questions, (IQuestionCsvParser.Column[])new IQuestionCsvParser.Column[]{IQuestionCsvParser.Column.ID(), IQuestionCsvParser.Column.question((String)"en"), IQuestionCsvParser.Column.sparqlQuery(), IQuestionCsvParser.Column.goldenAnswers()});
        wr.flush();
        fw.close();
        File f2 = new File(parentDir, "qald8trainBAD_QUESTIONS.csv ");
        f2.delete();
        FileWriter fw2 = new FileWriter(f2);
        CSVWriter wr2 = new CSVWriter((Writer)fw2, ';', '\"');
        IQuestionCsvParser.questionListToCsv((CSVWriter)wr2, (boolean)true, failQuestions, (IQuestionCsvParser.Column[])new IQuestionCsvParser.Column[]{IQuestionCsvParser.Column.ID(), IQuestionCsvParser.Column.question((String)"en"), IQuestionCsvParser.Column.sparqlQuery(), IQuestionCsvParser.Column.goldenAnswers()});
        wr2.flush();
        fw2.close();
        System.out.println("done qald8train");
    }

    public static void qald8test() throws Exception {
        FileReader rd = new FileReader(new File("c:/output/QALD8testtask1.csv"));
        File parentDir = new File("c:/output/qald8/");
        CSVReader csvReader = IQuestionCsvParser.readerForGoogleDocsCsvExports((Reader)rd, (int)1);
        List que = IQuestionCsvParser.csvToQuestionList((CSVReader)csvReader, (IQuestionCsvParser.Column[])new IQuestionCsvParser.Column[]{IQuestionCsvParser.Column.question((String)"en"), IQuestionCsvParser.Column.sparqlQuery(), IQuestionCsvParser.Column.ignore(), IQuestionCsvParser.Column.answerType(), IQuestionCsvParser.Column.aggregationFlag(), IQuestionCsvParser.Column.onlyDboFlag(), IQuestionCsvParser.Column.hybridFlag(), IQuestionCsvParser.Column.keywords((String)"en")});
        IQuestion removeMe = null;
        for (Object q : que) {
            if (!((String)q.getLanguageToQuestion().get("en")).equals("How old was Shockley when he died?")) continue;
            removeMe = q;
        }
        que.remove(removeMe);
        for (Object q : que) {
            String newSparql = SPARQLPrefixResolver.addMissingPrefixes((String)q.getSparqlQuery());
            q.setSparqlQuery(newSparql);
            if (SPARQL.isValidSparqlQuery((String)newSparql)) continue;
            throw new Exception("Sparql not valid " + (String)q.getLanguageToQuestion().get("en"));
        }
        AnswerSyncer.syncAnswers((List)que, (String)"http://dbpedia.org/sparql");
        int id = 1;
        for (IQuestion q : que) {
            if (q.getGoldenAnswers().isEmpty()) {
                throw new Exception("Answerset empty");
            }
            q.setId("" + id++);
        }
        QaldJson json = EJQuestionFactory.getQaldJson((List)que);
        EJDataset header = new EJDataset();
        header.setId("qald-8-test-multilingual");
        json.setDataset(header);
        ExtendedQALDJSONLoader.writeJson((Object)json, (File)new File(parentDir, "qald-8-test-multilingual.json"), (boolean)true);
        File f2 = new File(parentDir, "qald8testGOOD_QUESTIONS.csv");
        f2.delete();
        FileWriter fw2 = new FileWriter(f2);
        CSVWriter wr2 = new CSVWriter((Writer)fw2, ';', '\"');
        IQuestionCsvParser.questionListToCsv((CSVWriter)wr2, (boolean)true, (List)que, (IQuestionCsvParser.Column[])new IQuestionCsvParser.Column[]{IQuestionCsvParser.Column.ID(), IQuestionCsvParser.Column.question((String)"en"), IQuestionCsvParser.Column.sparqlQuery(), IQuestionCsvParser.Column.goldenAnswers()});
        wr2.close();
        fw2.close();
        System.out.println("qald8test done");
    }
}

