/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.aksw.qa.commons.load.json.EJDataset;
import org.aksw.qa.commons.load.json.EJQuestionFactory;
import org.aksw.qa.commons.load.json.ExtendedJson;
import org.aksw.qa.commons.load.json.ExtendedQALDJSONLoader;
import org.aksw.qa.commons.load.json.QaldJson;
import org.aksw.qa.commons.qald.Fail;
import org.aksw.qa.commons.qald.Qald7Question;
import org.aksw.qa.commons.qald.Qald7QuestionFactory;
import org.aksw.qa.commons.sparql.ThreadedSPARQL;
import org.aksw.qa.commons.store.StoreQALDXML;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;

public class Qald7CreationTool {
    private static final String DBO_URI = "http://dbpedia.org/ontology/";
    private static final String RES_URI = "http://dbpedia.org/resource/";
    private int duplicate = 0;
    public static final Set<Dataset> MULTILINGUAL_TRAIN_TEST_SETS = ImmutableSet.of((Object)Dataset.QALD3_Test_dbpedia, (Object)Dataset.QALD4_Test_Multilingual, (Object)Dataset.QALD5_Test_Multilingual, (Object)Dataset.QALD6_Test_Multilingual, (Object)Dataset.QALD3_Train_dbpedia, (Object)Dataset.QALD4_Train_Multilingual, (Object[])new Dataset[]{Dataset.QALD4_Train_Multilingual, Dataset.QALD5_Train_Multilingual, Dataset.QALD6_Train_Multilingual});
    public static final Set<Dataset> HYBRID_SETS = ImmutableSet.of((Object)Dataset.QALD4_Test_Hybrid, (Object)Dataset.QALD4_Train_Hybrid, (Object)Dataset.QALD5_Test_Hybrid, (Object)Dataset.QALD5_Train_Hybrid, (Object)Dataset.QALD6_Test_Hybrid, (Object)Dataset.QALD6_Train_Hybrid, (Object[])new Dataset[0]);
    private final ThreadedSPARQL sparql;

    public Qald7CreationTool() {
        this.sparql = new ThreadedSPARQL(90, "http://dbpedia.org/sparql");
    }

    public Qald7CreationTool(String sparqlEndpoint, int timeout) {
        this.sparql = new ThreadedSPARQL(timeout, sparqlEndpoint);
    }

    public Set<Qald7Question> getQald7HybridQuestions(Set<Dataset> datasets) {
        HashSet<Qald7Question> out = new HashSet<Qald7Question>();
        for (Dataset dataset : datasets) {
            for (Qald7Question it : Qald7QuestionFactory.createInstances((Collection)LoaderController.load((Dataset)dataset))) {
                it.setHybrid(Boolean.valueOf(true));
                out.add(it);
            }
        }
        return out;
    }

    public void createQald7HybridDataset(Set<Dataset> hybridDatasets, String path, String filenameWithoutExtension) {
        this.createQald7Dataset(this.getQald7HybridQuestions(hybridDatasets), path, filenameWithoutExtension);
    }

    public void createQald7MultilingualTrainDataset(Set<Dataset> datasets, boolean fileReport, boolean autocorrectOnlydbo, String path, String filenameWithoutExtension) {
        Set questions = this.loadAndAnnotateTrain(datasets, autocorrectOnlydbo);
        this.createQald7Dataset(this.extractGoodTrainQuestionsFromAnnotated(questions), path, filenameWithoutExtension);
        if (fileReport) {
            this.createFileReport(questions, path + "BadQuestionsfileReport.txt", new HashSet());
        }
    }

    public Set<Qald7Question> getQald7MultilingualTrainQuestions(Set<Dataset> datasets, boolean autocorrectOnlydbo) {
        return this.extractGoodTrainQuestionsFromAnnotated(this.loadAndAnnotateTrain(datasets, autocorrectOnlydbo));
    }

    public Set<Qald7Question> loadAndAnnotateTrain(Set<Dataset> datasets, boolean autocorrectOnlyDBO) {
        ArrayList<Qald7Question> allDatasetQuestions = new ArrayList<Qald7Question>();
        for (Dataset dataset : datasets) {
            List questions = Qald7QuestionFactory.createInstances((Collection)LoaderController.load((Dataset)dataset));
            for (Qald7Question question : questions) {
                allDatasetQuestions.add(question);
                question.setFromDataset(dataset);
                question.setFails(new HashSet());
                if (!this.checkAtleastSixLanguages((IQuestion)question)) {
                    question.addFail(Fail.MISSING_LANGUAGES);
                }
                if (!this.checkKeywordsPresent((IQuestion)question)) {
                    question.addFail(Fail.MISSING_KEYWORDS);
                }
                if (!this.checkAnswertypeSet((IQuestion)question)) {
                    question.addFail(Fail.ANSWERTYPE_NOT_SET);
                }
                if (!this.checkSparqlPresent((IQuestion)question)) {
                    question.addFail(Fail.SPARQL_MISSING);
                } else {
                    try {
                        if (this.checkIsOnlydbo(question.getSparqlQuery()) != question.getOnlydbo().booleanValue()) {
                            if (autocorrectOnlyDBO) {
                                question.setOnlydbo(Boolean.valueOf(this.checkIsOnlydbo(question.getSparqlQuery())));
                            } else {
                                question.addFail(Fail.ISONLYDBO_WRONG);
                            }
                        }
                    }
                    catch (QueryParseException e) {
                        question.addFail(Fail.SPARQL_PARSE_ERROR);
                    }
                }
                Set answersFromServer = Collections.emptySet();
                try {
                    answersFromServer = this.getAnswersFromServer((IQuestion)question);
                }
                catch (ExecutionException e) {
                    question.addFail(Fail.SPARQL_NOT_EXECUTABLE);
                }
                question.setServerAnswers(answersFromServer);
                Set answersFromDataset = question.getGoldenAnswers();
                Set set = answersFromDataset = answersFromDataset == null ? Collections.emptySet() : answersFromDataset;
                if (answersFromDataset.isEmpty()) {
                    question.addFail(Fail.NO_ANSWERS_IN_DATASET);
                }
                if (answersFromDataset.containsAll(answersFromServer) && answersFromServer.containsAll(answersFromDataset)) continue;
                question.addFail(Fail.ANSWERSET_DIFFERS);
            }
        }
        return this.findAndSelectBestDuplicate(allDatasetQuestions);
    }

    private boolean checkSparqlPresent(IQuestion q) {
        return !StringUtils.isEmpty((CharSequence)q.getSparqlQuery());
    }

    private boolean checkAnswertypeSet(IQuestion q) {
        return !Strings.isNullOrEmpty((String)q.getAnswerType());
    }

    private boolean checkKeywordsPresent(IQuestion q) {
        for (String it : q.getLanguageToQuestion().keySet()) {
            if (q.getLanguageToKeywords().get(it) != null && !((List)q.getLanguageToKeywords().get(it)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean checkAtleastSixLanguages(IQuestion q) {
        return q.getLanguageToQuestion().values().size() >= 6;
    }

    public Set<String> getAnswersFromServer(IQuestion q) throws ExecutionException {
        Set answersFromServer = this.sparql.sparql(q.getSparqlQuery());
        answersFromServer = answersFromServer == null ? Collections.emptySet() : answersFromServer;
        HashSet<String> answersFromServerAsString = new HashSet<String>();
        for (RDFNode it : answersFromServer) {
            if (it.isResource()) {
                answersFromServerAsString.add(it.asResource().getURI());
                continue;
            }
            answersFromServerAsString.add(it.asLiteral().getString());
        }
        return answersFromServerAsString;
    }

    private void addSave(Map<String, List<Qald7Question>> map, String question, Qald7Question q) {
        if (map.get(question) == null) {
            map.put(question, new ArrayList());
        }
        map.get(question).add(q);
    }

    private Set<Qald7Question> findAndSelectBestDuplicate(List<Qald7Question> questions) {
        this.duplicate = 0;
        HashSet<Qald7Question> out = new HashSet<Qald7Question>();
        HashMap questionToObject = new HashMap();
        for (Object it : questions) {
            this.addSave(questionToObject, (String)it.getLanguageToQuestion().get("en"), it);
        }
        try {
            out.addAll((Collection)questionToObject.get(null));
            questionToObject.remove(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        block3: for (Object it : questionToObject.keySet()) {
            if (((List)questionToObject.get(it)).size() == 1) {
                out.addAll((Collection)questionToObject.get(it));
                continue;
            }
            int min = Integer.MAX_VALUE;
            this.duplicate += ((List)questionToObject.get(it)).size() - 1;
            for (Qald7Question q : (List)questionToObject.get(it)) {
                if (q.getFails().size() >= min) continue;
                min = q.getFails().size();
            }
            for (Qald7Question q : (List)questionToObject.get(it)) {
                if (q.getFails().size() != min) continue;
                out.add(q);
                continue block3;
            }
        }
        return out;
    }

    private Set<Qald7Question> extractGoodTrainQuestionsFromAnnotated(Set<Qald7Question> questions) {
        HashSet<Qald7Question> goodQuestions = new HashSet<Qald7Question>();
        for (Qald7Question question : questions) {
            if (!question.getFails().isEmpty()) continue;
            goodQuestions.add(question);
        }
        return goodQuestions;
    }

    private Set<Qald7Question> extractBadQuestionsFromAnnotated(Set<Qald7Question> questions, Set<Fail> ignoreFlags) {
        HashSet<Qald7Question> badQuestions = new HashSet<Qald7Question>();
        for (Qald7Question question : questions) {
            HashSet flags = new HashSet(question.getFails());
            flags.removeAll(ignoreFlags);
            if (flags.isEmpty()) continue;
            badQuestions.add(question);
        }
        return badQuestions;
    }

    private void createQald7Dataset(Set<Qald7Question> allQuestions, String path, String filenameWithoutExtension) {
        ArrayList<Qald7Question> goodQuestions = new ArrayList<Qald7Question>();
        int newId = 0;
        for (Qald7Question question : allQuestions) {
            question.setId("" + newId++);
            goodQuestions.add(question);
        }
        EJDataset jsonDataset = new EJDataset();
        jsonDataset.setId(filenameWithoutExtension);
        QaldJson qaldJson = EJQuestionFactory.getQaldJson(goodQuestions);
        qaldJson.setDataset(jsonDataset);
        ExtendedJson extendedJson = EJQuestionFactory.getExtendedJson(goodQuestions);
        extendedJson.setDataset(jsonDataset);
        try {
            ExtendedQALDJSONLoader.writeJson((Object)qaldJson, (File)new File(path + "QaldJson_" + filenameWithoutExtension + ".json"), (boolean)true);
            ExtendedQALDJSONLoader.writeJson((Object)extendedJson, (File)new File(path + "ExtendedJson_" + filenameWithoutExtension + ".json"), (boolean)true);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            StoreQALDXML xml = new StoreQALDXML(filenameWithoutExtension);
            for (IQuestion iQuestion : goodQuestions) {
                xml.write(iQuestion);
            }
            xml.close(path + "XML_" + filenameWithoutExtension + ".xml", filenameWithoutExtension);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void createFileReportForTestQuestions(Set<Dataset> datasets, boolean autocorrectOnlydbo, String pathAndFilenameWithExtension, Set<Fail> ignoreFlags) {
        this.createFileReport(this.loadAndAnnotateTrain(datasets, autocorrectOnlydbo), pathAndFilenameWithExtension, ignoreFlags);
    }

    public void createFileReport(Set<Qald7Question> allQuestions, String pathAndFilenameWithExtension, Set<Fail> ignoreFlags) {
        String n = System.getProperty("line.separator");
        Set badQuestions = this.extractBadQuestionsFromAnnotated(allQuestions, ignoreFlags);
        StringBuilder out = new StringBuilder();
        HashSet<Dataset> datasets = new HashSet<Dataset>();
        for (Qald7Question question : badQuestions) {
            datasets.add(question.getFromDataset());
            Set answersFromServer = question.getServerAnswers();
            Set answersFromDataset = question.getGoldenAnswers();
            answersFromDataset = answersFromDataset == null ? Collections.emptySet() : answersFromDataset;
            answersFromServer = answersFromServer == null ? Collections.emptySet() : answersFromServer;
            HashSet inDatasetNotinServer = new HashSet(answersFromDataset);
            HashSet inServerNotinDataset = new HashSet(answersFromServer);
            inDatasetNotinServer.removeAll(answersFromServer);
            inServerNotinDataset.removeAll(answersFromDataset);
            HashSet flags = new HashSet(question.getFails());
            flags.removeAll(ignoreFlags);
            out.append("_____________________________________________________" + n);
            out.append("| Question Dataset: " + question.getFromDataset().name() + " Id: " + question.getId() + n);
            out.append("| Flags: " + ((Object)flags).toString() + n);
            out.append("| Question: " + (String)question.getLanguageToQuestion().get("en") + n);
            if (!inDatasetNotinServer.isEmpty() || !inServerNotinDataset.isEmpty()) {
                out.append("| Sparql Query:" + n);
                out.append("| " + question.getSparqlQuery().replaceAll("\\s", " ") + n);
                out.append("| Answers in dataset and not in Server response" + n);
                out.append("|" + ((Object)inDatasetNotinServer).toString() + n + n);
                out.append("| Answers in Server response and not in Dataset" + n);
                out.append("|" + ((Object)inServerNotinDataset).toString() + n);
            }
            out.append("_____________________________________________________" + n);
        }
        out.append("From Datasets :" + ((Object)datasets).toString() + n);
        out.append("Unique Questions total in all Datasets: " + allQuestions.size() + " Faulty: " + badQuestions.size() + " beforehand removed duplicates: " + this.duplicate);
        File file = new File(pathAndFilenameWithExtension);
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(out.toString());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean checkIsOnlydbo(String sparqlQuery) throws QueryParseException {
        if (sparqlQuery == null) {
            return false;
        }
        Query q = QueryFactory.create((String)sparqlQuery);
        PrefixMapping prefixMap = q.getPrefixMapping();
        HashMap map = new HashMap(prefixMap.getNsPrefixMap());
        HashSet remove = new HashSet();
        for (Map.Entry it : map.entrySet()) {
            if (!((String)it.getKey()).equals("rdf") && !((String)it.getKey()).equals("rdfs") && !((String)it.getValue()).equals(DBO_URI) && !((String)it.getValue()).equals(RES_URI)) continue;
            remove.add(it);
        }
        map.entrySet().removeAll(remove);
        return map.isEmpty();
    }

    public void destroy() {
        this.sparql.destroy();
    }

    public static void main(String[] args) {
        Qald7CreationTool tool = new Qald7CreationTool();
        tool.createQald7HybridDataset(HYBRID_SETS, "", "qald-7-train-hybrid");
        tool.createQald7MultilingualTrainDataset(MULTILINGUAL_TRAIN_TEST_SETS, true, true, "", "qald-7-train-multilingual");
        tool.sparql.destroy();
        System.out.println("duplcates " + tool.duplicate);
        System.out.println("Done");
    }
}

