/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class QALD4_EvaluationUtils {
    static Logger log = LoggerFactory.getLogger(QALD4_EvaluationUtils.class);

    public static double precision(Set<RDFNode> systemAnswer, IQuestion question) {
        if (systemAnswer == null) {
            return 0.0;
        }
        double precision = 0.0;
        Set goldenRDFNodes = QALD4_EvaluationUtils.answersToRDFNode((Set)question.getGoldenAnswers());
        if (question.getPseudoSparqlQuery() != null) {
            if (QALD4_EvaluationUtils.isSelectType((String)question.getPseudoSparqlQuery())) {
                Sets.SetView intersection = Sets.intersection((Set)goldenRDFNodes, systemAnswer);
                if (systemAnswer.size() != 0) {
                    precision = (double)intersection.size() / (double)systemAnswer.size();
                }
            } else if (QALD4_EvaluationUtils.isAskType((String)question.getPseudoSparqlQuery())) {
                if (systemAnswer.size() == 1) {
                    RDFNode ans = systemAnswer.iterator().next();
                    RDFNode goldstandardAns = (RDFNode)goldenRDFNodes.iterator().next();
                    if (ans.toString().equals(goldstandardAns.toString())) {
                        precision = 1.0;
                    }
                }
            } else {
                log.error("Unsupported Query Type" + question.getPseudoSparqlQuery());
            }
        } else if (question.getSparqlQuery() != null) {
            if (QALD4_EvaluationUtils.isSelectType((String)question.getSparqlQuery())) {
                Sets.SetView intersection = Sets.intersection((Set)goldenRDFNodes, systemAnswer);
                if (systemAnswer.size() != 0) {
                    precision = (double)intersection.size() / (double)systemAnswer.size();
                }
            } else if (QALD4_EvaluationUtils.isAskType((String)question.getSparqlQuery())) {
                if (systemAnswer.size() == 1) {
                    RDFNode ans = systemAnswer.iterator().next();
                    RDFNode goldstandardAns = (RDFNode)goldenRDFNodes.iterator().next();
                    if (ans.toString().equals(goldstandardAns.toString())) {
                        precision = 1.0;
                    }
                }
            } else {
                log.error("Unsupported Query Type" + question.getSparqlQuery());
            }
        }
        return precision;
    }

    public static double recall(Set<RDFNode> systemAnswer, IQuestion question) {
        if (systemAnswer == null) {
            return 0.0;
        }
        double recall = 0.0;
        Set goldenRDFNodes = QALD4_EvaluationUtils.answersToRDFNode((Set)question.getGoldenAnswers());
        if (question.getPseudoSparqlQuery() != null) {
            if (QALD4_EvaluationUtils.isSelectType((String)question.getPseudoSparqlQuery())) {
                if (question.getAggregation().booleanValue()) {
                    recall = 1.0;
                }
                Sets.SetView intersection = Sets.intersection(systemAnswer, (Set)goldenRDFNodes);
                if (goldenRDFNodes.size() != 0) {
                    recall = (double)intersection.size() / (double)goldenRDFNodes.size();
                }
            } else if (QALD4_EvaluationUtils.isAskType((String)question.getPseudoSparqlQuery())) {
                recall = 1.0;
            } else {
                log.error("Unsupported Query Type" + question.getPseudoSparqlQuery());
            }
        } else if (question.getSparqlQuery() != null) {
            if (QALD4_EvaluationUtils.isSelectType((String)question.getSparqlQuery())) {
                if (question.getAggregation().booleanValue()) {
                    recall = 1.0;
                }
                Sets.SetView intersection = Sets.intersection(systemAnswer, (Set)goldenRDFNodes);
                if (goldenRDFNodes.size() != 0) {
                    recall = (double)intersection.size() / (double)goldenRDFNodes.size();
                }
            } else if (QALD4_EvaluationUtils.isAskType((String)question.getSparqlQuery())) {
                recall = 1.0;
            } else {
                log.error("Unsupported Query Type" + question.getSparqlQuery());
            }
        }
        return recall;
    }

    public static double fMeasure(Set<RDFNode> systemAnswers, IQuestion question) {
        double precision = QALD4_EvaluationUtils.precision(systemAnswers, (IQuestion)question);
        double recall = QALD4_EvaluationUtils.recall(systemAnswers, (IQuestion)question);
        double fMeasure = 0.0;
        if (precision + recall > 0.0) {
            fMeasure = 2.0 * precision * recall / (precision + recall);
        }
        return fMeasure;
    }

    public static boolean isAskType(String sparqlQuery) {
        if (sparqlQuery == null) {
            return false;
        }
        return sparqlQuery.contains("\nASK\n") || sparqlQuery.contains("ASK ");
    }

    private static boolean isSelectType(String sparqlQuery) {
        return sparqlQuery.contains("\nSELECT\n") || sparqlQuery.contains("SELECT ");
    }

    private static Set<RDFNode> answersToRDFNode(Set<String> answers) {
        HashSet<RDFNode> tmp = new HashSet<RDFNode>();
        for (String s : answers) {
            tmp.add((RDFNode)new ResourceImpl(s));
        }
        return tmp;
    }
}

