/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.qald.IQuestionCsvParser;
import org.apache.jena.ext.com.google.common.base.Strings;

/*
 * Exception performing whole class analysis ignored.
 */
public class IQuestionCsvParser {
    public static String ARRAY_SPLIT = ",";
    public static String NULL_DEFAULT = "";

    private static IQuestion csvRowToQuestion(String[] csvRow, Column ... columns) throws IOException {
        List<String> splittedcsv = Arrays.asList(csvRow);
        List<Column> cols = Arrays.asList(columns);
        int maxFor = cols.size() < splittedcsv.size() ? cols.size() : splittedcsv.size();
        Question question = new Question();
        block15: for (int i = 0; i < maxFor; ++i) {
            Column colIt = cols.get(i);
            String csvIt = splittedcsv.get(i).trim();
            Column.ColEnum en = colIt.getEnum();
            String lang = colIt.getState();
            try {
                switch (1.$SwitchMap$org$aksw$qa$commons$qald$IQuestionCsvParser$Column$ColEnum[en.ordinal()]) {
                    case 1: {
                        question.setAggregation(IQuestionCsvParser.parseBoolean((String)csvIt));
                        break;
                    }
                    case 2: {
                        question.setAnswerType(csvIt.toLowerCase());
                        break;
                    }
                    case 3: {
                        question.getGoldenAnswers().addAll(IQuestionCsvParser.parseStringArray((String)csvIt));
                        break;
                    }
                    case 4: {
                        question.setHybrid(IQuestionCsvParser.parseBoolean((String)csvIt));
                        break;
                    }
                    case 5: {
                        List keywords = IQuestionCsvParser.parseStringArray((String)csvIt);
                        if (!question.getLanguageToKeywords().keySet().contains(lang)) {
                            question.getLanguageToKeywords().put(lang, keywords);
                            break;
                        }
                        ((List)question.getLanguageToKeywords().get(lang)).addAll(keywords);
                        break;
                    }
                    case 6: {
                        question.setOnlydbo(IQuestionCsvParser.parseBoolean((String)csvIt));
                        break;
                    }
                    case 7: {
                        question.setOutOfScope(IQuestionCsvParser.parseBoolean((String)csvIt));
                        break;
                    }
                    case 8: {
                        question.setPseudoSparqlQuery(csvIt);
                        break;
                    }
                    case 9: {
                        question.getLanguageToQuestion().put(lang, csvIt);
                        break;
                    }
                    case 10: {
                        question.setSparqlQuery(csvIt);
                        break;
                    }
                    case 11: {
                        continue block15;
                    }
                    default: {
                        throw new ParseException("Unidentified column wrapper", 0);
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw new IOException(String.format("@Column %d : |%s| should be parsed as: %s", i, csvIt, colIt.getEnum().name()), e);
            }
        }
        return question;
    }

    public static List<IQuestion> csvToQuestionList(CSVReader reader, Column ... columns) throws IOException {
        Vector<IQuestion> questions = new Vector<IQuestion>();
        String[] row = reader.readNext();
        int lineCounter = 1;
        while (row != null) {
            try {
                questions.add(IQuestionCsvParser.csvRowToQuestion((String[])row, (Column[])columns));
            }
            catch (IOException e) {
                throw new IOException(String.format("Couldn't parse csv: @Line %s " + e.getMessage(), lineCounter), e.getCause());
            }
            row = reader.readNext();
            ++lineCounter;
        }
        return questions;
    }

    public static void questionListToCsv(CSVWriter writer, boolean columnDescriptorgRow, List<IQuestion> questions, Column ... columns) throws IOException {
        if (columnDescriptorgRow) {
            int index = 0;
            String[] names = new String[columns.length];
            for (Column it : columns) {
                names[index] = it.getEnum().name();
                if (it.getState() != null) {
                    int n = index;
                    names[n] = names[n] + String.format(" [%s]", it.getState());
                }
                ++index;
            }
            writer.writeNext(names);
        }
        for (IQuestion it : questions) {
            ArrayList<String> colString = new ArrayList<String>(columns.length);
            block16: for (Column colIt : Arrays.asList(columns)) {
                Column.ColEnum en = colIt.getEnum();
                switch (1.$SwitchMap$org$aksw$qa$commons$qald$IQuestionCsvParser$Column$ColEnum[en.ordinal()]) {
                    case 1: {
                        colString.add(Objects.toString(it.getAggregation(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 2: {
                        colString.add(Objects.toString(it.getAnswerType(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 3: {
                        colString.add(Objects.toString(it.getGoldenAnswers(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 4: {
                        colString.add(Objects.toString(it.getHybrid(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 12: {
                        colString.add(Objects.toString(it.getId(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 5: {
                        colString.add(Objects.toString(it.getLanguageToKeywords().get(colIt.getState()), NULL_DEFAULT));
                        continue block16;
                    }
                    case 6: {
                        colString.add(Objects.toString(it.getOnlydbo(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 7: {
                        colString.add(Objects.toString(it.getOutOfScope(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 8: {
                        colString.add(Objects.toString(it.getPseudoSparqlQuery(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 9: {
                        colString.add(Objects.toString(it.getLanguageToQuestion().get(colIt.getState()), NULL_DEFAULT));
                        continue block16;
                    }
                    case 10: {
                        colString.add(Objects.toString(it.getSparqlQuery(), NULL_DEFAULT));
                        continue block16;
                    }
                    case 11: {
                        colString.add(NULL_DEFAULT);
                        continue block16;
                    }
                }
                throw new IOException("No case statement for enum.");
            }
            String[] ls = new String[colString.size()];
            colString.toArray(ls);
            writer.writeNext(ls);
        }
    }

    private static Boolean parseBoolean(String boolStr) throws IOException {
        if (Strings.isNullOrEmpty((String)boolStr)) {
            throw new IOException(String.format("Coluldn't parse Boolean :|%s| empy or null not allowed.", boolStr));
        }
        String cleaned = boolStr.trim().toLowerCase();
        if (cleaned.matches(Boolean.TRUE.toString()) || cleaned.matches(Boolean.FALSE.toString())) {
            return Boolean.parseBoolean(cleaned);
        }
        throw new IOException(String.format("Coluldn't parse Boolean :|%s| is not valid.", boolStr));
    }

    private static List<String> parseStringArray(String arrayStr) {
        String cleaned = arrayStr.trim();
        if (cleaned.startsWith("[") || cleaned.startsWith("{")) {
            cleaned = cleaned.substring(1);
        }
        if (cleaned.endsWith("]") || cleaned.endsWith("}")) {
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        return Arrays.asList(cleaned.split(ARRAY_SPLIT));
    }

    public static CSVReader readerForGoogleDocsCsvExports(Reader reader, int skipLines) {
        return new CSVReader(reader, ',', '\"', skipLines);
    }

    public static void main(String[] args) throws Exception {
    }
}

