/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;

/*
 * Exception performing whole class analysis ignored.
 */
public class EvaluationUtils {
    public static double precision(String sparqlQueryString, String targetSPARQLQueryString, String endpoint) {
        boolean targetAnswer;
        boolean answer;
        Query sparqlQuery = QueryFactory.create((String)sparqlQueryString, (Syntax)Syntax.syntaxARQ);
        sparqlQuery.setDistinct(true);
        Query targetSPARQLQuery = QueryFactory.create((String)targetSPARQLQueryString, (Syntax)Syntax.syntaxARQ);
        double precision = 0.0;
        if (sparqlQuery.isSelectType() && targetSPARQLQuery.isSelectType()) {
            Set nodes = EvaluationUtils.executeSelect((Query)sparqlQuery, (String)endpoint);
            Set targetNodes = EvaluationUtils.executeSelect((Query)targetSPARQLQuery, (String)endpoint);
            Sets.SetView intersection = Sets.intersection((Set)nodes, (Set)targetNodes);
            if (nodes.size() != 0) {
                precision = (double)intersection.size() / (double)nodes.size();
            }
        } else if (sparqlQuery.isAskType() && targetSPARQLQuery.isAskType() && (answer = EvaluationUtils.executeAsk((Query)sparqlQuery, (String)endpoint)) == (targetAnswer = EvaluationUtils.executeAsk((Query)targetSPARQLQuery, (String)endpoint))) {
            precision = 1.0;
        }
        return precision;
    }

    public static double recall(String sparqlQueryString, String targetSPARQLQueryString, String endpoint) {
        Query sparqlQuery = QueryFactory.create((String)sparqlQueryString, (Syntax)Syntax.syntaxARQ);
        sparqlQuery.setDistinct(true);
        Query targetSPARQLQuery = QueryFactory.create((String)targetSPARQLQueryString, (Syntax)Syntax.syntaxARQ);
        double recall = 0.0;
        if (sparqlQuery.isSelectType() && targetSPARQLQuery.isSelectType()) {
            if (!sparqlQuery.getAggregators().isEmpty() && !targetSPARQLQuery.getAggregators().isEmpty()) {
                return 1.0;
            }
            Set nodes = EvaluationUtils.executeSelect((Query)sparqlQuery, (String)endpoint);
            Set targetNodes = EvaluationUtils.executeSelect((Query)targetSPARQLQuery, (String)endpoint);
            Sets.SetView intersection = Sets.intersection((Set)nodes, (Set)targetNodes);
            if (nodes.size() != 0) {
                recall = (double)intersection.size() / (double)targetNodes.size();
            }
        } else if (sparqlQuery.isAskType() && targetSPARQLQuery.isAskType()) {
            recall = 1.0;
        }
        return recall;
    }

    public static double fMeasure(String sparqlQuery, String targetSPARQLQuery, String endpoint) {
        double precision = EvaluationUtils.precision((String)sparqlQuery, (String)targetSPARQLQuery, (String)endpoint);
        double recall = EvaluationUtils.recall((String)sparqlQuery, (String)targetSPARQLQuery, (String)endpoint);
        double fMeasure = 0.0;
        if (precision + recall > 0.0) {
            fMeasure = 2.0 * precision * recall / (precision + recall);
        }
        return fMeasure;
    }

    public static Set<RDFNode> executeSelect(Query query, String endpoint) {
        if (query.isQueryResultStar()) {
            return null;
        }
        QueryEngineHTTP qe = new QueryEngineHTTP(endpoint, query);
        ArrayList<String> defaultGraph = new ArrayList<String>();
        defaultGraph.add("http://dbpedia.org");
        qe.setDefaultGraphURIs(defaultGraph);
        ResultSet rs = qe.execSelect();
        List projectVars = query.getProjectVars();
        String projectionVar = !projectVars.isEmpty() && query.getAggregators().isEmpty() ? ((Var)query.getProjectVars().get(0)).getName() : (String)rs.getResultVars().get(0);
        HashSet<RDFNode> nodes = new HashSet<RDFNode>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            RDFNode rdfNode = qs.get(projectionVar);
            nodes.add(rdfNode);
        }
        return nodes;
    }

    public static boolean executeAsk(Query query, String endpoint) {
        QueryEngineHTTP qe = new QueryEngineHTTP(endpoint, query);
        ArrayList<String> defaultGraph = new ArrayList<String>();
        defaultGraph.add("http://dbpedia.org");
        qe.setDefaultGraphURIs(defaultGraph);
        boolean ret = qe.execAsk();
        return ret;
    }
}

