/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.measure;

import java.util.Set;
import org.aksw.qa.commons.utils.CollectionUtils;
import org.aksw.qa.commons.utils.SPARQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SPARQLBasedEvaluation {
    private static Logger logger = LoggerFactory.getLogger(SPARQLBasedEvaluation.class);

    public static double precision(String sparqlQueryString, String targetSPARQLQueryString, String endpoint) {
        double precision = 0.0;
        if (SPARQLBasedEvaluation.isSelectType((String)sparqlQueryString) && SPARQLBasedEvaluation.isSelectType((String)targetSPARQLQueryString)) {
            Set nodes = SPARQLExecutor.executeSelect((String)sparqlQueryString, (String)endpoint).getStringSet();
            Set targetNodes = SPARQLExecutor.executeSelect((String)targetSPARQLQueryString, (String)endpoint).getStringSet();
            Set intersection = CollectionUtils.intersection((Set)nodes, (Set)targetNodes);
            if (nodes.size() != 0) {
                precision = (double)intersection.size() / (double)nodes.size();
            }
        } else if (SPARQLBasedEvaluation.isAskType((String)sparqlQueryString) && SPARQLBasedEvaluation.isAskType((String)targetSPARQLQueryString)) {
            boolean targetAnswer;
            boolean answer = SPARQLExecutor.executeAsk((String)sparqlQueryString, (String)endpoint);
            if (answer == (targetAnswer = SPARQLExecutor.executeAsk((String)targetSPARQLQueryString, (String)endpoint).booleanValue())) {
                precision = 1.0;
            }
        } else {
            logger.error("Not implemented SPARQL query type.");
        }
        return precision;
    }

    public static double recall(String sparqlQueryString, String targetSPARQLQueryString, String endpoint) {
        double recall = 0.0;
        if (SPARQLBasedEvaluation.isSelectType((String)sparqlQueryString) && SPARQLBasedEvaluation.isSelectType((String)targetSPARQLQueryString)) {
            if (SPARQLBasedEvaluation.hasAggregations((String)sparqlQueryString) && SPARQLBasedEvaluation.hasAggregations((String)targetSPARQLQueryString)) {
                return 1.0;
            }
            Set nodes = SPARQLExecutor.executeSelect((String)sparqlQueryString, (String)endpoint).getStringSet();
            Set targetNodes = SPARQLExecutor.executeSelect((String)targetSPARQLQueryString, (String)endpoint).getStringSet();
            Set intersection = CollectionUtils.intersection((Set)nodes, (Set)targetNodes);
            if (nodes.size() != 0) {
                recall = (double)intersection.size() / (double)targetNodes.size();
            }
        } else if (SPARQLBasedEvaluation.isAskType((String)sparqlQueryString) && SPARQLBasedEvaluation.isAskType((String)targetSPARQLQueryString)) {
            recall = 1.0;
        } else {
            logger.error("Not implemented SPARQL query type.");
        }
        return recall;
    }

    public static double fMeasure(String sparqlQuery, String targetSPARQLQuery, String endpoint) {
        double precision = SPARQLBasedEvaluation.precision((String)sparqlQuery, (String)targetSPARQLQuery, (String)endpoint);
        double recall = SPARQLBasedEvaluation.recall((String)sparqlQuery, (String)targetSPARQLQuery, (String)endpoint);
        double fMeasure = 0.0;
        if (precision + recall > 0.0) {
            fMeasure = 2.0 * precision * recall / (precision + recall);
        }
        return fMeasure;
    }

    private static boolean isAskType(String sparqlQuery) {
        return sparqlQuery.contains("\nASK\n") || sparqlQuery.contains("ASK ");
    }

    private static boolean isSelectType(String sparqlQuery) {
        return sparqlQuery.contains("\nSELECT\n") || sparqlQuery.contains("SELECT ");
    }

    private static boolean hasAggregations(String query) {
        return query.toLowerCase().contains("count") || query.toLowerCase().contains("sum");
    }
}

