/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.measure;

import java.util.HashSet;
import java.util.Set;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnswerBasedEvaluation {
    private static Logger log = LoggerFactory.getLogger(AnswerBasedEvaluation.class);

    public static double precision(Set<String> systemAnswer, IQuestion question) {
        if (systemAnswer == null) {
            return 0.0;
        }
        double precision = 0.0;
        Set goldenStrings = AnswerBasedEvaluation.answersToString((Set)question.getGoldenAnswers());
        if (question.getPseudoSparqlQuery() != null) {
            if (AnswerBasedEvaluation.isSelectType((String)question.getPseudoSparqlQuery())) {
                Set intersection = CollectionUtils.intersection((Set)goldenStrings, systemAnswer);
                if (systemAnswer.size() != 0) {
                    precision = (double)intersection.size() / (double)systemAnswer.size();
                }
            } else if (AnswerBasedEvaluation.isAskType((String)question.getPseudoSparqlQuery())) {
                if (systemAnswer.size() == 1) {
                    String ans = systemAnswer.iterator().next();
                    String goldstandardAns = (String)goldenStrings.iterator().next();
                    if (ans.toString().equals(goldstandardAns.toString())) {
                        precision = 1.0;
                    }
                }
            } else {
                log.error("Unsupported Query Type" + question.getPseudoSparqlQuery());
            }
        } else if (question.getSparqlQuery() != null) {
            if (AnswerBasedEvaluation.isSelectType((String)question.getSparqlQuery())) {
                Set intersection = CollectionUtils.intersection((Set)goldenStrings, systemAnswer);
                if (systemAnswer.size() != 0) {
                    precision = (double)intersection.size() / (double)systemAnswer.size();
                }
            } else if (AnswerBasedEvaluation.isAskType((String)question.getSparqlQuery())) {
                if (systemAnswer.size() == 1) {
                    String ans = systemAnswer.iterator().next();
                    String goldstandardAns = (String)goldenStrings.iterator().next();
                    if (ans.toString().equals(goldstandardAns.toString())) {
                        precision = 1.0;
                    }
                }
            } else {
                log.error("Unsupported Query Type" + question.getSparqlQuery());
            }
        }
        return precision;
    }

    public static double recall(Set<String> systemAnswer, IQuestion question) {
        if (systemAnswer == null) {
            return 0.0;
        }
        double recall = 0.0;
        Set goldenStrings = AnswerBasedEvaluation.answersToString((Set)question.getGoldenAnswers());
        Boolean aggregation = question.getAggregation() == null ? false : question.getAggregation();
        if (question.getPseudoSparqlQuery() != null) {
            if (AnswerBasedEvaluation.isSelectType((String)question.getPseudoSparqlQuery())) {
                if (aggregation.booleanValue()) {
                    recall = 1.0;
                }
                Set intersection = CollectionUtils.intersection(systemAnswer, (Set)goldenStrings);
                if (goldenStrings.size() != 0) {
                    recall = (double)intersection.size() / (double)goldenStrings.size();
                }
            } else if (AnswerBasedEvaluation.isAskType((String)question.getPseudoSparqlQuery())) {
                recall = 1.0;
            } else {
                log.error("Unsupported Query Type" + question.getPseudoSparqlQuery());
            }
        } else if (question.getSparqlQuery() != null) {
            if (AnswerBasedEvaluation.isSelectType((String)question.getSparqlQuery())) {
                if (aggregation.booleanValue()) {
                    recall = 1.0;
                }
                Set intersection = CollectionUtils.intersection(systemAnswer, (Set)goldenStrings);
                if (goldenStrings.size() != 0) {
                    recall = (double)intersection.size() / (double)goldenStrings.size();
                }
            } else if (AnswerBasedEvaluation.isAskType((String)question.getSparqlQuery())) {
                recall = 1.0;
            } else {
                log.error("Unsupported Query Type" + question.getSparqlQuery());
            }
        }
        return recall;
    }

    public static double fMeasure(Set<String> systemAnswers, IQuestion question) {
        double precision = AnswerBasedEvaluation.precision(systemAnswers, (IQuestion)question);
        double recall = AnswerBasedEvaluation.recall(systemAnswers, (IQuestion)question);
        double fMeasure = 0.0;
        if (precision + recall > 0.0) {
            fMeasure = 2.0 * precision * recall / (precision + recall);
        }
        return fMeasure;
    }

    public static boolean isAskType(String sparqlQuery) {
        String query = sparqlQuery.toUpperCase();
        return query.contains("\nASK\n") || query.contains("ASK ");
    }

    public static boolean isSelectType(String sparqlQuery) {
        String query = sparqlQuery.toUpperCase();
        return query.contains("\nSELECT\n") || query.contains("SELECT ");
    }

    private static Set<String> answersToString(Set<String> answers) {
        HashSet tmp = CollectionUtils.newHashSet();
        for (String s : answers) {
            tmp.add(s);
        }
        return tmp;
    }
}

