/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.stanford;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDFS;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBpediaIndex {
    private Logger log = LoggerFactory.getLogger(DBpediaIndex.class);
    public String FIELD_NAME_SUBJECT = "subject";
    public String FIELD_NAME_PREDICATE = "predicate";
    public String FIELD_NAME_OBJECT = "object";
    private int numberOfDocsRetrievedFromIndex = 100;
    private Directory directory;
    private IndexSearcher isearcher;
    private DirectoryReader ireader;
    private IndexWriter iwriter;
    private SimpleAnalyzer analyzer;

    public DBpediaIndex() {
        try {
            Path index = Paths.get("resources/indexOntology", new String[0]);
            this.analyzer = new SimpleAnalyzer();
            if (!index.toFile().exists()) {
                index.toFile().mkdir();
                IndexWriterConfig config = new IndexWriterConfig((Analyzer)this.analyzer);
                this.directory = new MMapDirectory(index);
                this.iwriter = new IndexWriter(this.directory, config);
                this.index();
            } else {
                this.directory = new MMapDirectory(index);
            }
            this.ireader = DirectoryReader.open((Directory)this.directory);
            this.isearcher = new IndexSearcher((IndexReader)this.ireader);
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public ArrayList<String> search(String object) {
        ArrayList uris = Lists.newArrayList();
        try {
            ScoreDoc[] hits;
            this.log.debug("\t start asking index...");
            QueryParser qp = new QueryParser(this.FIELD_NAME_OBJECT, (Analyzer)this.analyzer);
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)this.numberOfDocsRetrievedFromIndex);
            this.isearcher.search(qp.createPhraseQuery(this.FIELD_NAME_OBJECT, object), (Collector)collector);
            for (ScoreDoc hit : hits = collector.topDocs().scoreDocs) {
                Document hitDoc = this.isearcher.doc(hit.doc);
                uris.add(hitDoc.get(this.FIELD_NAME_SUBJECT));
            }
            this.log.debug("\t finished asking index...");
        }
        catch (Exception e) {
            this.log.error(e.getLocalizedMessage() + " -> " + object, (Throwable)e);
        }
        return uris;
    }

    public void close() {
        try {
            this.ireader.close();
            this.directory.close();
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void index() {
        try {
            Model dbpedia = ModelFactory.createDefaultModel();
            dbpedia.read(this.getClass().getClassLoader().getResource("dbpedia_2015-10.owl").getPath(), "RDF/XML");
            StmtIterator stmts = dbpedia.listStatements(null, RDFS.label, (RDFNode)null);
            while (stmts.hasNext()) {
                Statement stmt = (Statement)stmts.next();
                RDFNode label = stmt.getObject();
                if (!label.asLiteral().getLanguage().equals("en")) continue;
                this.addDocumentToIndex(stmt.getSubject(), "rdfs:label", label.asLiteral().getString());
                NodeIterator comment = dbpedia.listObjectsOfProperty(stmt.getSubject(), RDFS.comment);
                while (comment.hasNext()) {
                    RDFNode next = comment.next();
                    if (!next.asLiteral().getLanguage().equals("en")) continue;
                    this.addDocumentToIndex(stmt.getSubject(), "rdfs:comment", next.asLiteral().getString());
                }
            }
            this.iwriter.commit();
            this.iwriter.close();
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void addDocumentToIndex(Resource resource, String predicate, String object) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StringField(this.FIELD_NAME_SUBJECT, resource.getURI(), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.FIELD_NAME_PREDICATE, predicate, Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_NAME_OBJECT, object, Field.Store.YES));
        this.iwriter.addDocument((Iterable)doc);
    }
}

