/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.json;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.load.json.EJAnswers;
import org.aksw.qa.commons.load.json.EJBinding;
import org.aksw.qa.commons.load.json.EJHead;
import org.aksw.qa.commons.load.json.EJLanguage;
import org.aksw.qa.commons.load.json.EJMetadata;
import org.aksw.qa.commons.load.json.EJQuestionEntry;
import org.aksw.qa.commons.load.json.EJResults;
import org.aksw.qa.commons.load.json.ExtendedJson;
import org.aksw.qa.commons.load.json.QaldJson;
import org.aksw.qa.commons.load.json.QaldQuery;
import org.aksw.qa.commons.load.json.QaldQuestion;
import org.aksw.qa.commons.load.json.QaldQuestionEntry;
import org.aksw.qa.commons.utils.SPARQLExecutor;
import org.apache.jena.ext.com.google.common.base.Joiner;
import org.apache.jena.rdf.model.RDFNode;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EJQuestionFactory {
    public static final String SPLIT_KEYWORDS_ON = ",";

    private EJQuestionFactory() {
    }

    public static List<IQuestion> getQuestionsFromExtendedJson(ExtendedJson json) {
        return EJQuestionFactory.getQuestionsFromExtendedJson((ExtendedJson)json, null);
    }

    @Deprecated
    public static List<IQuestion> getQuestionsFromExtendedJson(ExtendedJson json, String deriveUri) {
        ArrayList<IQuestion> out = new ArrayList<IQuestion>();
        for (EJQuestionEntry it : json.getQuestions()) {
            Question question = new Question();
            out.add((IQuestion)question);
            question.setId(it.getQuestion().getId() + "");
            question.setAnswerType(it.getQuestion().getAnswertype());
            if (it.getQuestion().getMetadata() != null) {
                EJMetadata meta = it.getQuestion().getMetadata();
                question.setAggregation(meta.getAggregation());
                question.setHybrid(meta.getHybrid());
                question.setOnlydbo(meta.getOnlydbo());
            }
            for (EJLanguage lang : it.getQuestion().getLanguage()) {
                question.setSparqlQuery(lang.getSparql());
                HashMap<String, String> langToQuestion = new HashMap<String, String>();
                HashMap<String, List<String>> langToKeywords = new HashMap<String, List<String>>();
                langToQuestion.put(lang.getLanguage(), lang.getQuestion());
                question.setLanguageToQuestion(langToQuestion);
                langToKeywords.put(lang.getLanguage(), Arrays.asList(lang.getKeywords().split(",")));
                question.setLanguageToKeywords(langToKeywords);
            }
            if (deriveUri != null && question.getSparqlQuery() != null) {
                HashSet<String> set = new HashSet<String>();
                Set answers = SPARQLExecutor.sparql((String)deriveUri, (String)question.getSparqlQuery());
                for (RDFNode answ : answers) {
                    set.add(answ.toString());
                }
                question.setGoldenAnswers(set);
                continue;
            }
            EJAnswers answers = it.getQuestion().getAnswers();
            EJQuestionFactory.getAnswersFromAnswerObject((EJAnswers)answers, (IQuestion)question);
        }
        return out;
    }

    public static ExtendedJson getExtendedJson(List<IQuestion> questions) {
        ExtendedJson ex = new ExtendedJson();
        for (IQuestion question : questions) {
            EJQuestionEntry entry = new EJQuestionEntry();
            if (question.getHybrid() != null || question.getOnlydbo() != null || question.getAggregation() != null || question.getOutOfScope().booleanValue()) {
                EJMetadata metadata = new EJMetadata();
                metadata.setAggregation(question.getAggregation());
                metadata.setOnlydbo(question.getOnlydbo());
                metadata.setHybrid(question.getHybrid());
                entry.getQuestion().setMetadata(metadata);
            }
            if (!Strings.isNullOrEmpty((String)question.getAnswerType())) {
                entry.getQuestion().setAnswertype(question.getAnswerType());
            }
            if (!Strings.isNullOrEmpty((String)question.getId())) {
                entry.getQuestion().setId(question.getId());
            } else {
                entry.getQuestion().setId("undefined");
            }
            for (String langStr : question.getLanguageToQuestion().keySet()) {
                EJLanguage language = new EJLanguage();
                entry.getQuestion().getLanguage().add(language);
                if (question.getLanguageToKeywords().get(langStr) != null && !((List)question.getLanguageToKeywords().get(langStr)).isEmpty()) {
                    language.setKeywords(Joiner.on((String)",").join((Iterable)question.getLanguageToKeywords().get(langStr)));
                }
                language.setLanguage(langStr);
                language.setQuestion((String)question.getLanguageToQuestion().get(langStr));
                language.setSparql(EJQuestionFactory.removeAdditinalWhitespaceCharacters((String)question.getSparqlQuery()));
            }
            EJAnswers answers = new EJAnswers();
            entry.getQuestion().setAnswers(answers);
            EJQuestionFactory.setAnswersInJson((EJAnswers)answers, (IQuestion)question);
            ex.addQuestions(entry);
        }
        return ex;
    }

    public static QaldJson getQaldJson(List<IQuestion> questions) {
        QaldJson json = new QaldJson();
        for (IQuestion question : questions) {
            QaldQuestionEntry questionEntry = new QaldQuestionEntry();
            for (Map.Entry entry : question.getLanguageToQuestion().entrySet()) {
                QaldQuestion q = new QaldQuestion();
                q.setLanguage((String)entry.getKey()).setString((String)entry.getValue());
                if (question.getLanguageToKeywords() != null && question.getLanguageToKeywords().get(entry.getKey()) != null) {
                    q.setKeywords(Joiner.on((String)", ").join((Iterable)question.getLanguageToKeywords().get(entry.getKey())));
                }
                questionEntry.getQuestion().add(q);
            }
            questionEntry.setId(question.getId());
            questionEntry.setAnswertype(question.getAnswerType());
            questionEntry.setAggregation(question.getAggregation());
            questionEntry.setOnlydbo(question.getOnlydbo());
            questionEntry.setHybrid(question.getHybrid());
            QaldQuery language = new QaldQuery();
            language.setSparql(EJQuestionFactory.removeAdditinalWhitespaceCharacters((String)question.getSparqlQuery()));
            language.setPseudo(EJQuestionFactory.removeAdditinalWhitespaceCharacters((String)question.getPseudoSparqlQuery()));
            questionEntry.setQuery(language);
            EJAnswers answers = new EJAnswers();
            questionEntry.getAnswers().add(answers);
            EJHead head = new EJHead();
            answers.setHead(head);
            EJQuestionFactory.setAnswersInJson((EJAnswers)answers, (IQuestion)question);
            json.getQuestions().add(questionEntry);
        }
        return json;
    }

    private static String removeAdditinalWhitespaceCharacters(String in) {
        if (in == null) {
            return null;
        }
        String out = in.replaceAll("\\s+", " ").trim();
        return out;
    }

    public static List<IQuestion> getQuestionsFromJson(Object json) {
        return EJQuestionFactory.getQuestionsFromJson((Object)json, null);
    }

    @Deprecated
    public static List<IQuestion> getQuestionsFromJson(Object json, String deriveUri) {
        if (json instanceof ExtendedJson) {
            return EJQuestionFactory.getQuestionsFromExtendedJson((ExtendedJson)((ExtendedJson)json), (String)deriveUri);
        }
        if (json instanceof QaldJson) {
            return EJQuestionFactory.getQuestionsFromQaldJson((QaldJson)((QaldJson)json), (String)deriveUri);
        }
        return null;
    }

    public static List<IQuestion> getQuestionsFromQaldJson(QaldJson json) {
        return EJQuestionFactory.getQuestionsFromQaldJson((QaldJson)json, null);
    }

    @Deprecated
    public static List<IQuestion> getQuestionsFromQaldJson(QaldJson json, String deriveUri) {
        ArrayList<IQuestion> questions = new ArrayList<IQuestion>();
        for (QaldQuestionEntry it : json.getQuestions()) {
            Question question = new Question();
            question.setId(it.getId());
            question.setAnswerType(it.getAnswertype());
            question.setAggregation(it.getAggregation());
            question.setOnlydbo(it.getOnlydbo());
            question.setHybrid(it.getHybrid());
            if (it.getQuery() != null) {
                question.setPseudoSparqlQuery(it.getQuery().getPseudo());
                question.setSparqlQuery(it.getQuery().getSparql());
            }
            for (QaldQuestion qQuestion : it.getQuestion()) {
                question.getLanguageToQuestion().put(qQuestion.getLanguage(), qQuestion.getString());
                if (qQuestion.getKeywords() == null || qQuestion.getKeywords().isEmpty()) continue;
                question.getLanguageToKeywords().put(qQuestion.getLanguage(), Arrays.asList(qQuestion.getKeywords().split(",\\s*")));
            }
            if (deriveUri != null && question.getSparqlQuery() != null) {
                HashSet<String> set = new HashSet<String>();
                Set answers = SPARQLExecutor.sparql((String)deriveUri, (String)question.getSparqlQuery());
                for (RDFNode answ : answers) {
                    set.add(answ.toString());
                }
                question.setGoldenAnswers(set);
            } else {
                for (EJAnswers answerObject : it.getAnswers()) {
                    EJQuestionFactory.getAnswersFromAnswerObject((EJAnswers)answerObject, (IQuestion)question);
                }
            }
            questions.add((IQuestion)question);
        }
        return questions;
    }

    private static void getAnswersFromAnswerObject(EJAnswers answerObject, IQuestion question) {
        if (answerObject == null) {
            return;
        }
        if (answerObject.getBoolean() != null) {
            question.getGoldenAnswers().add(answerObject.getBoolean() + "");
        }
        if (answerObject.getResults() != null) {
            Vector answerVector = answerObject.getResults().getBindings();
            for (HashMap answerMap : answerVector) {
                for (EJBinding bind : answerMap.values()) {
                    question.getGoldenAnswers().add(bind.getValue());
                }
            }
        }
    }

    private static void setAnswersInJson(EJAnswers answers, IQuestion question) {
        EJHead head = answers.getHead();
        String ansType = question.getAnswerType();
        if (ansType == null || ansType.isEmpty()) {
            ansType = "not set";
        }
        answers.setResults(new EJResults());
        switch (ansType.toLowerCase()) {
            case "boolean": {
                try {
                    answers.setBoolean(Boolean.valueOf(((String)question.getGoldenAnswers().iterator().next()).contains("true")));
                }
                catch (Exception e) {
                    System.out.println("sss");
                }
                break;
            }
            case "date": {
                head.getVars().add("date");
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType("literal");
                    binding.setValue(golden);
                    bindMap.put("date", binding);
                    answers.getResults().getBindings().add(bindMap);
                }
                break;
            }
            case "resource": {
                head.getVars().add("uri");
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType("uri");
                    binding.setValue(golden);
                    bindMap.put("uri", binding);
                    answers.getResults().getBindings().add(bindMap);
                }
                break;
            }
            case "number": {
                head.getVars().add("c");
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType("literal");
                    binding.setValue(golden);
                    bindMap.put("c", binding);
                    answers.getResults().getBindings().add(bindMap);
                }
                break;
            }
            case "string": {
                head.getVars().add("string");
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType("literal");
                    binding.setValue(golden);
                    bindMap.put("string", binding);
                    answers.getResults().getBindings().add(bindMap);
                }
                break;
            }
            default: {
                head.getVars().add(ansType);
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType(ansType);
                    binding.setValue(golden);
                    bindMap.put(ansType, binding);
                    answers.getResults().getBindings().add(bindMap);
                }
            }
        }
    }

    public static ExtendedJson fromQaldToExtended(QaldJson json) {
        if (json == null) {
            return null;
        }
        ExtendedJson exJson = new ExtendedJson();
        exJson.setDataset(json.getDataset());
        for (QaldQuestionEntry qaldQuestionEntry : json.getQuestions()) {
            EJQuestionEntry exEntry = new EJQuestionEntry();
            exEntry.getQuestion().setId(qaldQuestionEntry.getId());
            exEntry.getQuestion().setAnswertype(qaldQuestionEntry.getAnswertype());
            if (!qaldQuestionEntry.getAnswers().isEmpty()) {
                exEntry.getQuestion().setAnswers((EJAnswers)qaldQuestionEntry.getAnswers().get(0));
            }
            EJMetadata meta = new EJMetadata();
            meta.setAggregation(qaldQuestionEntry.getAggregation());
            meta.setHybrid(qaldQuestionEntry.getHybrid());
            meta.setOnlydbo(qaldQuestionEntry.getOnlydbo());
            exEntry.getQuestion().setMetadata(meta);
            for (QaldQuestion qqIt : qaldQuestionEntry.getQuestion()) {
                EJLanguage lang = new EJLanguage();
                lang.setLanguage(qqIt.getLanguage());
                lang.setQuestion(qqIt.getString());
                lang.setKeywords(qqIt.getKeywords());
                lang.setSparql(qaldQuestionEntry.getQuery().getSparql());
                exEntry.getQuestion().getLanguage().add(lang);
            }
            exJson.getQuestions().add(exEntry);
        }
        return exJson;
    }

    public static QaldJson fromExtendedToQald(ExtendedJson exJson) {
        if (exJson == null) {
            return null;
        }
        QaldJson json = new QaldJson();
        json.setDataset(exJson.getDataset());
        for (EJQuestionEntry exEntry : exJson.getQuestions()) {
            QaldQuestionEntry qEntry = new QaldQuestionEntry();
            if (exEntry.getQuestion().getMetadata() != null) {
                EJMetadata meta = exEntry.getQuestion().getMetadata();
                qEntry.setAggregation(meta.getAggregation());
                qEntry.setHybrid(meta.getHybrid());
                qEntry.setOnlydbo(meta.getOnlydbo());
            }
            qEntry.setId(exEntry.getQuestion().getId());
            qEntry.setAnswertype(exEntry.getQuestion().getAnswertype());
            QaldQuery query = new QaldQuery();
            qEntry.setQuery(query);
            if (!exEntry.getQuestion().getLanguage().isEmpty()) {
                query.setSparql(((EJLanguage)exEntry.getQuestion().getLanguage().get(0)).getSparql());
            }
            for (EJLanguage lang : exEntry.getQuestion().getLanguage()) {
                QaldQuestion qQuestion = new QaldQuestion();
                qQuestion.setLanguage(lang.getLanguage());
                qQuestion.setString(lang.getQuestion());
                qQuestion.setKeywords(lang.getKeywords());
                qEntry.getQuestion().add(qQuestion);
            }
            qEntry.getAnswers().add(exEntry.getQuestion().getAnswers());
            json.getQuestions().add(qEntry);
        }
        return json;
    }
}

