/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.aksw.qa.commons.utils.DateFormatter;

public class EJBinding {
    private String datatype;
    private String type;
    private String value;
    private String xmllang;

    public String toString() {
        return "{Type: " + this.type + " Value: " + this.value + "}";
    }

    public String getType() {
        return this.type;
    }

    public EJBinding setType(String type) {
        this.type = type;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public EJBinding setValue(String value) {
        if (this.datatype == null) {
            this.value = value;
            return this;
        }
        switch (this.datatype) {
            case "http://www.w3.org/2001/XMLSchema#boolean": {
                this.value = Boolean.valueOf(value).toString();
                return this;
            }
            case "http://www.w3.org/2001/XMLSchema#date": {
                this.value = DateFormatter.formatDate((String)value);
                return this;
            }
        }
        this.value = value;
        return this;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    @JsonProperty(value="xml:lang")
    public String getXmllang() {
        return this.xmllang;
    }

    @JsonProperty(value="xml:lang")
    public void setXmllang(String xmllang) {
        this.xmllang = xmllang;
    }
}

