/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.datastructure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.utils.CollectionUtils;
import org.json.simple.JSONObject;

public class Question
implements IQuestion {
    private String id;
    private String answerType;
    private String pseudoSparqlQuery;
    private Map<String, String> sparqlQuery;
    private Boolean aggregation;
    private Boolean onlydbo;
    private Boolean outOfScope;
    private Boolean hybrid;
    private Map<String, String> languageToQuestion;
    private Map<String, List<String>> languageToKeywords;
    private Map<String, Set<String>> goldenAnswers;
    private JSONObject answerAsQALDJSON;

    public Question() {
        HashSet ga = CollectionUtils.newHashSet();
        this.goldenAnswers = new HashMap();
        this.goldenAnswers.put("en", ga);
        this.sparqlQuery = new HashMap();
        this.languageToQuestion = CollectionUtils.newLinkedHashMap();
        this.languageToKeywords = CollectionUtils.newLinkedHashMap();
    }

    public String toString() {
        return "Question [id=" + this.id + ", answerType=" + this.answerType + ", aggregation=" + this.aggregation + ", onlydbo=" + this.onlydbo + ", outOfScope=" + this.outOfScope + ", hybrid=" + this.hybrid + ", pseudoSparqlQuery=" + this.pseudoSparqlQuery + ", sparqlQuery=" + this.sparqlQuery + ", languageToQuestion=" + this.languageToQuestion + ", languageToKeywords=" + this.languageToKeywords + ", goldenAnswers=" + this.goldenAnswers + "]";
    }

    public void setValue(String valDescriptor, String val) {
        String valDescriptorLowerCase;
        switch (valDescriptorLowerCase = valDescriptor.toLowerCase()) {
            case "id": {
                this.id = val;
                break;
            }
            case "answertype": {
                this.answerType = val;
                break;
            }
            case "aggregation": {
                this.aggregation = Boolean.parseBoolean(val);
                break;
            }
            case "onlydbo": {
                this.onlydbo = Boolean.parseBoolean(val);
                break;
            }
            case "hybrid": {
                this.hybrid = Boolean.parseBoolean(val);
                break;
            }
        }
    }

    public String getAnswerType() {
        return this.answerType;
    }

    public void setAnswerType(String answerType) {
        this.answerType = answerType;
    }

    public String getPseudoSparqlQuery() {
        return this.pseudoSparqlQuery;
    }

    public void setPseudoSparqlQuery(String pseudoSparqlQuery) {
        this.pseudoSparqlQuery = pseudoSparqlQuery;
    }

    public String getSparqlQuery() {
        return (String)this.sparqlQuery.get("en");
    }

    public String getSparqlQuery(String lang) {
        return (String)this.sparqlQuery.get(lang);
    }

    public void setSparqlQuery(String sparqlQuery) {
        this.sparqlQuery.put("en", sparqlQuery);
    }

    public void setSparqlQuery(String lang, String sparqlQuery) {
        this.sparqlQuery.put(lang, sparqlQuery);
    }

    public Boolean getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(Boolean aggregation) {
        this.aggregation = aggregation;
    }

    public Boolean getOnlydbo() {
        return this.onlydbo;
    }

    public void setOnlydbo(Boolean onlydbo) {
        this.onlydbo = onlydbo;
    }

    public Boolean getOutOfScope() {
        return this.outOfScope;
    }

    public void setOutOfScope(Boolean outOfScope) {
        this.outOfScope = outOfScope;
    }

    public Boolean getHybrid() {
        return this.hybrid;
    }

    public void setHybrid(Boolean hybrid) {
        this.hybrid = hybrid;
    }

    public Map<String, String> getLanguageToQuestion() {
        return this.languageToQuestion;
    }

    public void setLanguageToQuestion(Map<String, String> languageToQuestion) {
        this.languageToQuestion = languageToQuestion;
    }

    public Map<String, List<String>> getLanguageToKeywords() {
        return this.languageToKeywords;
    }

    public void setLanguageToKeywords(Map<String, List<String>> languageToKeywords) {
        this.languageToKeywords = languageToKeywords;
    }

    public Set<String> getGoldenAnswers() {
        return (Set)this.goldenAnswers.get("en");
    }

    public Set<String> getGoldenAnswers(String lang) {
        return (Set)this.goldenAnswers.get(lang);
    }

    public void setGoldenAnswers(Set<String> goldenAnswers) {
        this.goldenAnswers.put("en", goldenAnswers);
    }

    public void setGoldenAnswers(String lang, Set<String> goldenAnswers) {
        this.goldenAnswers.put(lang, goldenAnswers);
    }

    public void setAnswerAsQALDJSON(JSONObject json) {
        this.answerAsQALDJSON = json;
    }

    public JSONObject getAnswerAsQALDJSON() {
        return this.answerAsQALDJSON;
    }

    public String getId() {
        return this.id + "";
    }

    public void setId(String id) {
        this.id = id;
    }
}

