/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.json;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.load.json.EJAnswers;
import org.aksw.qa.commons.load.json.EJBinding;
import org.aksw.qa.commons.load.json.EJHead;
import org.aksw.qa.commons.load.json.EJLanguage;
import org.aksw.qa.commons.load.json.EJQuestionEntry;
import org.aksw.qa.commons.load.json.EJResults;
import org.aksw.qa.commons.load.json.ExtendedJson;
import org.aksw.qa.commons.load.json.QaldJson;
import org.aksw.qa.commons.load.json.QaldQuery;
import org.aksw.qa.commons.load.json.QaldQuestion;
import org.aksw.qa.commons.load.json.QaldQuestionEntry;
import org.apache.jena.ext.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EJQuestionFactory {
    public static final String SPLIT_KEYWORDS_ON = ",";
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    private EJQuestionFactory() {
    }

    public static List<IQuestion> getQuestionsFromExtendedJson(ExtendedJson json) {
        ArrayList<IQuestion> out = new ArrayList<IQuestion>();
        for (EJQuestionEntry it : json.getQuestions()) {
            Question question = new Question();
            out.add(question);
            question.setId(it.getQuestion().getId() + "");
            question.setAnswerType(it.getQuestion().getAnswertype());
            for (EJLanguage lang : it.getQuestion().getLanguage()) {
                question.setSparqlQuery(lang.getSparql());
                HashMap<String, String> langToQuestion = new HashMap<String, String>();
                HashMap<String, List<String>> langToKeywords = new HashMap<String, List<String>>();
                langToQuestion.put(lang.getLanguage(), lang.getQuestion());
                question.setLanguageToQuestion(langToQuestion);
                langToKeywords.put(lang.getLanguage(), Arrays.asList(lang.getKeywords().split(SPLIT_KEYWORDS_ON)));
                question.setLanguageToKeywords(langToKeywords);
            }
            EJAnswers answers = it.getQuestion().getAnswers();
            EJQuestionFactory.getAnswersFromAnswerObject(answers, question);
        }
        return out;
    }

    public static ExtendedJson getExtendedJson(List<IQuestion> questions) {
        ExtendedJson ex = new ExtendedJson();
        for (IQuestion question : questions) {
            EJQuestionEntry entry = new EJQuestionEntry();
            if (!Strings.isNullOrEmpty((String)question.getAnswerType())) {
                entry.getQuestion().setAnswertype(question.getAnswerType());
            }
            if (!Strings.isNullOrEmpty((String)question.getId())) {
                entry.getQuestion().setId(question.getId());
            } else {
                entry.getQuestion().setId("undefined");
            }
            for (String langStr : question.getLanguageToQuestion().keySet()) {
                EJLanguage language = new EJLanguage();
                entry.getQuestion().getLanguage().add(language);
                if (question.getLanguageToKeywords().get(langStr) != null && !question.getLanguageToKeywords().get(langStr).isEmpty()) {
                    language.setKeywords(Joiner.on((String)SPLIT_KEYWORDS_ON).join((Iterable)question.getLanguageToKeywords().get(langStr)));
                }
                language.setLanguage(langStr);
                language.setQuestion(question.getLanguageToQuestion().get(langStr));
                language.setSparql(question.getSparqlQuery());
            }
            EJAnswers answers = new EJAnswers();
            entry.getQuestion().setAnswers(answers);
            EJQuestionFactory.setAnswersInJson(answers, question);
            ex.addQuestions(entry);
        }
        return ex;
    }

    public static QaldJson getQaldJson(List<IQuestion> questions) {
        QaldJson json = new QaldJson();
        for (IQuestion question : questions) {
            QaldQuestionEntry questionEntry = new QaldQuestionEntry();
            for (Map.Entry<String, String> entry : question.getLanguageToQuestion().entrySet()) {
                QaldQuestion q = new QaldQuestion();
                q.setLanguage(entry.getKey()).setString(entry.getValue());
                if (question.getLanguageToKeywords() != null && question.getLanguageToKeywords().get(entry.getKey()) != null) {
                    q.setKeywords(Joiner.on((String)", ").join((Iterable)question.getLanguageToKeywords().get(entry.getKey())));
                }
                questionEntry.getQuestion().add(q);
            }
            questionEntry.setId(question.getId());
            questionEntry.setAnswertype(question.getAnswerType());
            questionEntry.setAggregation(question.getAggregation());
            questionEntry.setOnlydbo(question.getOnlydbo());
            questionEntry.setHybrid(question.getHybrid());
            QaldQuery language = new QaldQuery();
            language.setSparql(question.getSparqlQuery());
            language.setPseudo(question.getPseudoSparqlQuery());
            questionEntry.setQuery(language);
            EJAnswers answers = new EJAnswers();
            questionEntry.getAnswers().add(answers);
            EJHead head = new EJHead();
            answers.setHead(head);
            EJQuestionFactory.setAnswersInJson(answers, question);
            json.getQuestions().add(questionEntry);
        }
        return json;
    }

    public static List<IQuestion> getQuestionsFromJson(Object json) {
        if (json instanceof ExtendedJson) {
            return EJQuestionFactory.getQuestionsFromExtendedJson((ExtendedJson)json);
        }
        if (json instanceof QaldJson) {
            return EJQuestionFactory.getQuestionsFromQaldJson((QaldJson)json);
        }
        return null;
    }

    public static List<IQuestion> getQuestionsFromQaldJson(QaldJson json) {
        ArrayList<IQuestion> questions = new ArrayList<IQuestion>();
        for (QaldQuestionEntry it : json.getQuestions()) {
            Question question = new Question();
            question.setId(it.getId());
            question.setAnswerType(it.getAnswertype());
            question.setAggregation(it.getAggregation());
            question.setOnlydbo(it.getOnlydbo());
            question.setHybrid(it.getHybrid());
            if (it.getQuery() != null) {
                question.setPseudoSparqlQuery(it.getQuery().getPseudo());
                question.setSparqlQuery(it.getQuery().getSparql());
            }
            for (QaldQuestion qQuestion : it.getQuestion()) {
                question.getLanguageToQuestion().put(qQuestion.getLanguage(), qQuestion.getString());
                if (qQuestion.getKeywords() == null || qQuestion.getKeywords().isEmpty()) continue;
                question.getLanguageToKeywords().put(qQuestion.getLanguage(), Arrays.asList(qQuestion.getKeywords().split(",\\s*")));
            }
            for (EJAnswers answerObject : it.getAnswers()) {
                EJQuestionFactory.getAnswersFromAnswerObject(answerObject, question);
            }
            questions.add(question);
        }
        return questions;
    }

    private static void getAnswersFromAnswerObject(EJAnswers answerObject, IQuestion question) {
        if (answerObject == null) {
            return;
        }
        if (answerObject.getBoolean() != null) {
            question.getGoldenAnswers().add(answerObject.getBoolean() + "");
        }
        if (answerObject.getResults() != null) {
            Vector<HashMap<String, EJBinding>> answerVector = answerObject.getResults().getBindings();
            for (HashMap<String, EJBinding> answerMap : answerVector) {
                for (EJBinding bind : answerMap.values()) {
                    question.getGoldenAnswers().add(bind.getValue());
                }
            }
        }
    }

    private static void setAnswersInJson(EJAnswers answers, IQuestion question) {
        EJHead head = answers.getHead();
        String ansType = question.getAnswerType();
        if (ansType == null || ansType.isEmpty()) {
            ansType = "not set";
        }
        answers.setResults(new EJResults());
        switch (ansType.toLowerCase()) {
            case "boolean": {
                answers.setBoolean(Boolean.TRUE.equals(Joiner.on((String)" ").join(question.getLanguageToQuestion().values()).toLowerCase().contains("true")));
                break;
            }
            case "date": {
                head.getVars().add("date");
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType("literal");
                    binding.setValue(golden);
                    bindMap.put("date", binding);
                    answers.getResults().getBindings().add(bindMap);
                }
                break;
            }
            case "resource": {
                head.getVars().add("uri");
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType("uri");
                    binding.setValue(golden);
                    bindMap.put("uri", binding);
                    answers.getResults().getBindings().add(bindMap);
                }
                break;
            }
            case "number": {
                head.getVars().add("c");
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType("literal");
                    binding.setValue(golden);
                    bindMap.put("c", binding);
                    answers.getResults().getBindings().add(bindMap);
                }
                break;
            }
            case "string": {
                head.getVars().add("string");
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType("literal");
                    binding.setValue(golden);
                    bindMap.put("string", binding);
                    answers.getResults().getBindings().add(bindMap);
                }
                break;
            }
            default: {
                head.getVars().add(ansType);
                for (String golden : question.getGoldenAnswers()) {
                    EJBinding binding = new EJBinding();
                    HashMap<String, EJBinding> bindMap = new HashMap<String, EJBinding>();
                    binding.setType(ansType);
                    binding.setValue(golden);
                    bindMap.put(ansType, binding);
                    answers.getResults().getBindings().add(bindMap);
                }
            }
        }
    }

    public static ExtendedJson fromQaldToExtended(QaldJson json) {
        if (json == null) {
            return null;
        }
        ExtendedJson exJson = new ExtendedJson();
        exJson.setDataset(json.getDataset());
        for (QaldQuestionEntry qaldQuestionEntry : json.getQuestions()) {
            EJQuestionEntry exEntry = new EJQuestionEntry();
            exEntry.getQuestion().setId(qaldQuestionEntry.getId());
            exEntry.getQuestion().setAnswertype(qaldQuestionEntry.getAnswertype());
            if (!qaldQuestionEntry.getAnswers().isEmpty()) {
                exEntry.getQuestion().setAnswers(qaldQuestionEntry.getAnswers().get(0));
            }
            for (QaldQuestion qqIt : qaldQuestionEntry.getQuestion()) {
                EJLanguage lang = new EJLanguage();
                lang.setLanguage(qqIt.getLanguage());
                lang.setQuestion(qqIt.getString());
                lang.setKeywords(qqIt.getKeywords());
                lang.setSparql(qaldQuestionEntry.getQuery().getSparql());
                exEntry.getQuestion().getLanguage().add(lang);
            }
            exJson.getQuestions().add(exEntry);
        }
        return exJson;
    }

    public static QaldJson fromExtendedToQald(ExtendedJson exJson) {
        if (exJson == null) {
            return null;
        }
        QaldJson json = new QaldJson();
        json.setDataset(exJson.getDataset());
        for (EJQuestionEntry exEntry : exJson.getQuestions()) {
            QaldQuestionEntry qEntry = new QaldQuestionEntry();
            qEntry.setId(exEntry.getQuestion().getId());
            qEntry.setAnswertype(exEntry.getQuestion().getAnswertype());
            QaldQuery query = new QaldQuery();
            qEntry.setQuery(query);
            if (!exEntry.getQuestion().getLanguage().isEmpty()) {
                query.setSparql(exEntry.getQuestion().getLanguage().get(0).getSparql());
            }
            for (EJLanguage lang : exEntry.getQuestion().getLanguage()) {
                QaldQuestion qQuestion = new QaldQuestion();
                qQuestion.setLanguage(lang.getLanguage());
                qQuestion.setString(lang.getQuestion());
                qQuestion.setKeywords(lang.getKeywords());
                qEntry.getQuestion().add(qQuestion);
            }
            qEntry.getAnswers().add(exEntry.getQuestion().getAnswers());
            json.getQuestions().add(qEntry);
        }
        return json;
    }
}

