/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.json;

import java.util.Objects;
import java.util.Vector;
import org.aksw.qa.commons.load.json.EJAnswers;
import org.aksw.qa.commons.load.json.EJLanguage;
import org.apache.jena.query.QueryFactory;

public class EJQuestion {
    private String id;
    private String answertype;
    private String confidence;
    private Vector<String> answeritemtype = new Vector();
    private Vector<EJLanguage> language = new Vector();
    private EJAnswers answers;

    public EJQuestion addAnsweritemtype(String name) {
        this.answeritemtype.add(name);
        return this;
    }

    public String toString() {
        return "\n  ID :" + this.id + "\n  Answertype: " + this.answertype + "\n  Confidence: " + this.confidence + "\n  Answeritemtype: " + this.answeritemtype.toString() + "\n  Language: " + Objects.toString(this.language) + "\n  Answers: " + Objects.toString(this.answers);
    }

    public String getId() {
        return this.id;
    }

    public String getAnswertype() {
        return this.answertype;
    }

    public String getConfidence() {
        return this.confidence;
    }

    public Vector<String> getAnsweritemtype() {
        return this.answeritemtype;
    }

    public Vector<EJLanguage> getLanguage() {
        return this.language;
    }

    public EJAnswers getAnswers() {
        return this.answers;
    }

    public EJQuestion setName(String id) {
        this.id = id;
        return this;
    }

    public EJQuestion setId(String id) {
        this.id = id;
        return this;
    }

    public EJQuestion setAnswertype(String answertype) {
        this.answertype = answertype;
        return this;
    }

    public EJQuestion setConfidence(String confidence) {
        this.confidence = confidence;
        return this;
    }

    public EJQuestion setAnsweritemtype(Vector<String> answeritemtype) {
        this.answeritemtype = answeritemtype;
        return this;
    }

    public EJQuestion setLanguage(Vector<EJLanguage> language) {
        this.language = language;
        for (EJLanguage lang : this.language) {
            try {
                QueryFactory.create((String)lang.getSparql());
            }
            catch (Exception e) {
                this.language.remove(lang);
            }
        }
        return this;
    }

    public EJQuestion setAnswers(EJAnswers answers) {
        this.answers = answers;
        return this;
    }
}

