/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.datastructure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.utils.CollectionUtils;
import org.json.simple.JSONObject;

public class Question
implements IQuestion {
    private String id;
    private String answerType;
    private String pseudoSparqlQuery;
    private Map<String, String> sparqlQuery;
    private Boolean aggregation;
    private Boolean onlydbo;
    private Boolean outOfScope;
    private Boolean hybrid;
    private Map<String, String> languageToQuestion;
    private Map<String, List<String>> languageToKeywords;
    private Map<String, Set<String>> goldenAnswers;
    private JSONObject answerAsQALDJSON;

    public Question() {
        HashSet ga = CollectionUtils.newHashSet();
        this.goldenAnswers = new HashMap<String, Set<String>>();
        this.goldenAnswers.put("en", ga);
        this.sparqlQuery = new HashMap<String, String>();
        this.languageToQuestion = CollectionUtils.newLinkedHashMap();
        this.languageToKeywords = CollectionUtils.newLinkedHashMap();
    }

    @Override
    public String toString() {
        return "Question [id=" + this.id + ", answerType=" + this.answerType + ", aggregation=" + this.aggregation + ", onlydbo=" + this.onlydbo + ", outOfScope=" + this.outOfScope + ", hybrid=" + this.hybrid + ", pseudoSparqlQuery=" + this.pseudoSparqlQuery + ", sparqlQuery=" + this.sparqlQuery + ", languageToQuestion=" + this.languageToQuestion + ", languageToKeywords=" + this.languageToKeywords + ", goldenAnswers=" + this.goldenAnswers + "]";
    }

    @Override
    public void setValue(String valDescriptor, String val) {
        switch (valDescriptor = valDescriptor.toLowerCase()) {
            case "id": {
                this.id = val;
                break;
            }
            case "answertype": {
                this.answerType = val;
                break;
            }
            case "aggregation": {
                this.aggregation = Boolean.parseBoolean(val);
                break;
            }
            case "onlydbo": {
                this.onlydbo = Boolean.parseBoolean(val);
                break;
            }
            case "hybrid": {
                this.hybrid = Boolean.parseBoolean(val);
                break;
            }
        }
    }

    @Override
    public String getAnswerType() {
        return this.answerType;
    }

    @Override
    public void setAnswerType(String answerType) {
        this.answerType = answerType;
    }

    @Override
    public String getPseudoSparqlQuery() {
        return this.pseudoSparqlQuery;
    }

    @Override
    public void setPseudoSparqlQuery(String pseudoSparqlQuery) {
        this.pseudoSparqlQuery = pseudoSparqlQuery;
    }

    @Override
    public String getSparqlQuery() {
        return this.sparqlQuery.get("en");
    }

    public String getSparqlQuery(String lang) {
        return this.sparqlQuery.get(lang);
    }

    @Override
    public void setSparqlQuery(String sparqlQuery) {
        this.sparqlQuery.put("en", sparqlQuery);
    }

    public void setSparqlQuery(String lang, String sparqlQuery) {
        this.sparqlQuery.put(lang, sparqlQuery);
    }

    @Override
    public Boolean getAggregation() {
        return this.aggregation;
    }

    @Override
    public void setAggregation(Boolean aggregation) {
        this.aggregation = aggregation;
    }

    @Override
    public Boolean getOnlydbo() {
        return this.onlydbo;
    }

    @Override
    public void setOnlydbo(Boolean onlydbo) {
        this.onlydbo = onlydbo;
    }

    @Override
    public Boolean getOutOfScope() {
        return this.outOfScope;
    }

    @Override
    public void setOutOfScope(Boolean outOfScope) {
        this.outOfScope = outOfScope;
    }

    @Override
    public Boolean getHybrid() {
        return this.hybrid;
    }

    @Override
    public void setHybrid(Boolean hybrid) {
        this.hybrid = hybrid;
    }

    @Override
    public Map<String, String> getLanguageToQuestion() {
        return this.languageToQuestion;
    }

    @Override
    public void setLanguageToQuestion(Map<String, String> languageToQuestion) {
        this.languageToQuestion = languageToQuestion;
    }

    @Override
    public Map<String, List<String>> getLanguageToKeywords() {
        return this.languageToKeywords;
    }

    @Override
    public void setLanguageToKeywords(Map<String, List<String>> languageToKeywords) {
        this.languageToKeywords = languageToKeywords;
    }

    @Override
    public Set<String> getGoldenAnswers() {
        return this.goldenAnswers.get("en");
    }

    public Set<String> getGoldenAnswers(String lang) {
        return this.goldenAnswers.get(lang);
    }

    @Override
    public void setGoldenAnswers(Set<String> goldenAnswers) {
        this.goldenAnswers.put("en", goldenAnswers);
    }

    public void setGoldenAnswers(String lang, Set<String> goldenAnswers) {
        this.goldenAnswers.put(lang, goldenAnswers);
    }

    public void setAnswerAsQALDJSON(JSONObject json) {
        this.answerAsQALDJSON = json;
    }

    public JSONObject getAnswerAsQALDJSON() {
        return this.answerAsQALDJSON;
    }

    @Override
    public String getId() {
        return this.id + "";
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

