/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.datastructure;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Resource;

public class Entity
implements Serializable,
Comparable<Entity> {
    private static final long serialVersionUID = 7859357081713774767L;
    private String label = "";
    private String type = "";
    private List<Resource> posTypesAndCategories = new ArrayList<Resource>();
    private List<Resource> uris = new ArrayList<Resource>();
    private int offset;

    public Entity(String label, String type) {
        this.label = label;
        this.type = type;
    }

    public Entity() {
    }

    @Override
    public int compareTo(Entity o) {
        int otherLength;
        int thisLength = this.label.length();
        if (thisLength < (otherLength = o.label.length())) {
            return -1;
        }
        if (thisLength > otherLength) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.uris.get(0) == null ? other.uris.get(0) != null : !this.uris.get(0).equals((Object)other.uris.get(0))) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public String toString() {
        return this.label + "(uri: " + Joiner.on((String)", ").join(this.uris) + "; type: " + this.type + ")";
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public List<Resource> getPosTypesAndCategories() {
        return this.posTypesAndCategories;
    }

    public List<Resource> getUris() {
        return this.uris;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPosTypesAndCategories(List<Resource> posTypesAndCategories) {
        this.posTypesAndCategories = posTypesAndCategories;
    }

    public void setUris(List<Resource> uris) {
        this.uris = uris;
    }
}

